/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui;

import com.verdantartifice.primalmagick.client.books.ClientBookHelper;
import com.verdantartifice.primalmagick.client.gui.widgets.StaticBookPageButton;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BookType;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.BooksPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector2i;

public class StaticBookViewScreen
extends Screen {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final int PAGE_INDICATOR_TEXT_Y_OFFSET = 16;
    public static final int PAGE_TEXT_X_OFFSET = 36;
    public static final int PAGE_TEXT_Y_OFFSET = 30;
    protected static final int TEXT_WIDTH = 114;
    protected static final int TEXT_HEIGHT = 128;
    protected static final int LINE_HEIGHT = 9;
    protected static final int IMAGE_WIDTH = 192;
    protected static final int IMAGE_HEIGHT = 192;
    protected final boolean playTurnSound;
    protected final ResourceKey<?> requestedBookKey;
    protected final ResourceLocation requestedLanguageId;
    protected final int requestedTranslatedComprehension;
    protected final ResourceLocation requestedBgTexture;
    protected final Map<Vector2i, FormattedCharSequence> renderedLines = new HashMap<Vector2i, FormattedCharSequence>();
    protected BookView bookView;
    private PageButton forwardButton;
    private PageButton backButton;
    private int currentPage;
    private int cachedPage = -1;
    private Component pageMsg = CommonComponents.f_237098_;

    public StaticBookViewScreen() {
        this(ResourceKey.m_135785_(RegistryKeysPM.BOOKS, (ResourceLocation)BooksPM.TEST_BOOK.getId()), BookLanguagesPM.DEFAULT.getId(), 0, BookType.BOOK.getBackgroundTexture(), false);
    }

    public StaticBookViewScreen(ResourceKey<?> bookKey, ResourceLocation languageId, int translatedComprehension, ResourceLocation bgTexture) {
        this(bookKey, languageId, translatedComprehension, bgTexture, true);
    }

    private StaticBookViewScreen(ResourceKey<?> bookKey, ResourceLocation languageId, int translatedComprehension, ResourceLocation bgTexture, boolean playTurnSound) {
        super(GameNarrator.f_93310_);
        this.playTurnSound = playTurnSound;
        this.requestedBookKey = bookKey;
        this.requestedLanguageId = languageId;
        this.requestedTranslatedComprehension = translatedComprehension;
        this.requestedBgTexture = bgTexture;
    }

    public boolean setPage(int newPage) {
        int clampedPage = Mth.m_14045_((int)newPage, (int)0, (int)(this.getNumPages() - 1));
        if (clampedPage != this.currentPage) {
            this.currentPage = clampedPage;
            this.updateButtonVisibility();
            this.cachedPage = -1;
            return true;
        }
        return false;
    }

    protected void m_7856_() {
        BookLanguage lang = (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(this.requestedLanguageId);
        if (lang == null) {
            lang = (BookLanguage)BookLanguagesPM.DEFAULT.get();
        }
        int comp = LinguisticsManager.getComprehension((Player)this.f_96541_.f_91074_, lang);
        this.bookView = new BookView(this.requestedBookKey, lang.languageId(), Math.max(comp, this.requestedTranslatedComprehension));
        this.createMenuControls();
        this.createPageControlButtons();
    }

    protected void createMenuControls() {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 100, 196, 200, 20).m_253136_());
    }

    protected void createPageControlButtons() {
        int x = (this.f_96543_ - 192) / 2;
        this.forwardButton = (PageButton)this.m_142416_((GuiEventListener)new StaticBookPageButton(x + 116, 159, true, p_98297_ -> this.pageForward(), this.playTurnSound, this.requestedBgTexture));
        this.backButton = (PageButton)this.m_142416_((GuiEventListener)new StaticBookPageButton(x + 43, 159, false, p_98287_ -> this.pageBack(), this.playTurnSound, this.requestedBgTexture));
        this.updateButtonVisibility();
    }

    private int getNumPages() {
        return ClientBookHelper.getNumPages(this.bookView, this.f_96547_);
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.forwardButton.f_93624_ = this.currentPage < this.getNumPages() - 1;
        this.backButton.f_93624_ = this.currentPage > 0;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (super.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        switch (pKeyCode) {
            case 266: {
                this.backButton.m_5691_();
                return true;
            }
            case 267: {
                this.forwardButton.m_5691_();
                return true;
            }
        }
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderedLines.clear();
        this.m_280273_(guiGraphics);
        int xPos = (this.f_96543_ - 192) / 2;
        int yPos = 2;
        guiGraphics.m_280218_(this.requestedBgTexture, xPos, yPos, 0, 0, 192, 192);
        if (this.cachedPage != this.currentPage) {
            this.pageMsg = Component.m_237110_((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, Math.max(this.getNumPages(), 1)});
        }
        this.cachedPage = this.currentPage;
        int pageMsgWidth = this.f_96547_.m_92852_((FormattedText)this.pageMsg);
        guiGraphics.m_280614_(this.f_96547_, this.pageMsg, xPos - pageMsgWidth + 192 - 44, 18, 0, false);
        List<FormattedCharSequence> page = ClientBookHelper.getTextPage(this.bookView, this.cachedPage, this.f_96547_);
        for (int index = 0; index < page.size(); ++index) {
            int finalX = xPos + 36;
            int finalY = yPos + 30 + index * 9;
            this.renderedLines.put(new Vector2i(finalX, finalY), page.get(index));
            guiGraphics.m_280649_(this.f_96547_, page.get(index), finalX, finalY, 0, false);
        }
        this.getRenderedLineEntryAt(mouseX, mouseY).ifPresent(entry -> {
            int startX = ((Vector2i)entry.getKey()).x;
            FormattedCharSequence line = (FormattedCharSequence)entry.getValue();
            Style style = this.f_96547_.m_92865_().m_92338_(line, mouseX - startX);
            if (style != null && style.m_131186_() != null) {
                guiGraphics.m_280304_(this.f_96547_, style, mouseX, mouseY);
            }
        });
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected Optional<Map.Entry<Vector2i, FormattedCharSequence>> getRenderedLineEntryAt(int x, int y) {
        for (Map.Entry<Vector2i, FormattedCharSequence> entry : this.renderedLines.entrySet()) {
            Vector2i pos = entry.getKey();
            int lineWidth = this.f_96547_.m_92724_(entry.getValue());
            if (x < pos.x || x > pos.x + lineWidth || y < pos.y || y > pos.y + 9) continue;
            return Optional.ofNullable(entry);
        }
        return Optional.empty();
    }
}

