/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeEntryButton;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeIndexPage
extends AbstractPage {
    public static final OtherResearchTopic TOPIC = new OtherResearchTopic("recipe_index", 0);
    protected static final Component SEARCH_HINT = Component.m_237115_((String)"gui.recipebook.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    protected static final Logger LOGGER = LogManager.getLogger();
    protected List<IndexItem> contents = new ArrayList<IndexItem>();
    protected boolean firstPage;
    protected Optional<String> startingSearchText;
    @Nullable
    protected EditBox searchBox;
    @Nullable
    protected GrimoireScreen screen;

    public RecipeIndexPage() {
        this(false, Optional.empty());
    }

    public RecipeIndexPage(boolean first, Optional<String> searchText) {
        this.firstPage = first;
        this.startingSearchText = searchText;
    }

    @Nonnull
    public List<IndexItem> getContents() {
        return Collections.unmodifiableList(this.contents);
    }

    public boolean addContent(String entry, ItemStack stack) {
        return this.contents.add(new IndexItem(entry, stack));
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    @Override
    protected Component getTitleText() {
        return Component.m_237115_((String)"grimoire.primalmagick.recipe_index_header");
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        if (this.isFirstPage() && side == 0) {
            this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
            if (this.searchBox != null) {
                this.searchBox.m_88315_(guiGraphics, mouseX, mouseY, 0.0f);
            }
        }
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        this.screen = screen;
        if (this.isFirstPage() && side == 0) {
            Minecraft mc = Minecraft.m_91087_();
            this.searchBox = new EditBox(mc.f_91062_, x + 12, y + 3, 121, 14, (Component)Component.m_237115_((String)"itemGroup.search"));
            this.searchBox.m_94199_(50);
            this.searchBox.m_94182_(true);
            this.searchBox.m_94194_(true);
            this.searchBox.m_94202_(0xFFFFFF);
            this.searchBox.m_257771_(SEARCH_HINT);
            this.searchBox.m_94186_(true);
            this.startingSearchText.ifPresentOrElse(text -> {
                this.searchBox.m_94144_(text);
                this.searchBox.m_93692_(true);
            }, () -> {
                this.searchBox.m_94144_("");
                this.searchBox.m_93692_(false);
            });
            y += 24;
        }
        for (IndexItem item : this.getContents()) {
            screen.addWidgetToScreen(new RecipeEntryButton(x + 12 + side * 140, y, (Component)Component.m_237113_((String)item.name), screen, item.name, item.iconStack));
            y += 12;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.searchBox != null && this.searchBox.m_6375_(pMouseX, pMouseY, pButton)) {
            this.searchBox.m_93692_(true);
            return true;
        }
        if (this.searchBox != null) {
            this.searchBox.m_93692_(false);
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_7933_(pKeyCode, pScanCode, pModifiers)) {
            if (this.screen != null) {
                this.screen.checkRecipeSearchStringUpdate(this.searchBox.m_94155_());
            }
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_5534_(pCodePoint, pModifiers)) {
            if (this.screen != null) {
                this.screen.checkRecipeSearchStringUpdate(this.searchBox.m_94155_());
            }
            return true;
        }
        return super.m_5534_(pCodePoint, pModifiers);
    }

    private static class IndexItem {
        public final String name;
        public final ItemStack iconStack;

        public IndexItem(String name, ItemStack stack) {
            this.name = name;
            this.iconStack = stack;
        }
    }
}

