/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ConcoctingRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.DissolutionRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RitualRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.RunecarvingRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapedArcaneRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapedRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapelessArcaneRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.ShapelessRecipePage;
import com.verdantartifice.primalmagick.client.gui.grimoire.SmeltingRecipePage;
import com.verdantartifice.primalmagick.common.crafting.ConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.DissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.RitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.RunecarvingRecipe;
import com.verdantartifice.primalmagick.common.crafting.ShapedArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.ShapelessArcaneRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;

public class RecipePageFactory {
    @Nullable
    public static AbstractRecipePage createPage(@Nonnull Recipe<?> recipe, RegistryAccess registryAccess) {
        if (recipe instanceof ShapelessArcaneRecipe) {
            ShapelessArcaneRecipe sar = (ShapelessArcaneRecipe)recipe;
            return new ShapelessArcaneRecipePage(sar, registryAccess);
        }
        if (recipe instanceof ShapedArcaneRecipe) {
            ShapedArcaneRecipe sar = (ShapedArcaneRecipe)recipe;
            return new ShapedArcaneRecipePage(sar, registryAccess);
        }
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe sr = (ShapelessRecipe)recipe;
            return new ShapelessRecipePage(sr, registryAccess);
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe sr = (ShapedRecipe)recipe;
            return new ShapedRecipePage(sr, registryAccess);
        }
        if (recipe instanceof RitualRecipe) {
            RitualRecipe rr = (RitualRecipe)recipe;
            return new RitualRecipePage(rr, registryAccess);
        }
        if (recipe instanceof RunecarvingRecipe) {
            RunecarvingRecipe rr = (RunecarvingRecipe)recipe;
            return new RunecarvingRecipePage(rr, registryAccess);
        }
        if (recipe instanceof ConcoctingRecipe) {
            ConcoctingRecipe cr = (ConcoctingRecipe)recipe;
            return new ConcoctingRecipePage(cr, registryAccess);
        }
        if (recipe instanceof SmeltingRecipe) {
            SmeltingRecipe sr = (SmeltingRecipe)recipe;
            return new SmeltingRecipePage(sr, registryAccess);
        }
        if (recipe instanceof DissolutionRecipe) {
            DissolutionRecipe dr = (DissolutionRecipe)recipe;
            return new DissolutionRecipePage(dr, registryAccess);
        }
        return null;
    }
}

