/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractPage;
import com.verdantartifice.primalmagick.client.gui.widgets.InactiveWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemStackWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemTagWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.KnowledgeWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ProgressButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ResearchWidget;
import com.verdantartifice.primalmagick.common.research.Knowledge;
import com.verdantartifice.primalmagick.common.research.ResearchStage;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class RequirementsPage
extends AbstractPage {
    protected static final int ITEMS_PER_ROW = 7;
    protected ResearchStage stage;

    public RequirementsPage(ResearchStage stage) {
        this.stage = stage;
    }

    @Override
    protected boolean renderTopTitleBar() {
        return false;
    }

    @Override
    protected Component getTitleText() {
        return Component.m_237115_((String)"grimoire.primalmagick.requirements_header");
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        Object obj;
        int index;
        List<Boolean> completion;
        int startX = x;
        int startY = y;
        y += 27;
        Minecraft mc = Minecraft.m_91087_();
        if (!this.stage.getMustObtain().isEmpty()) {
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            completion = this.stage.getObtainRequirementCompletion((Player)mc.f_91074_);
            for (index = 0; index < this.stage.getMustObtain().size(); ++index) {
                if (index > 0 && index % 7 == 0) {
                    x = startX;
                    y += 18;
                }
                if ((obj = this.stage.getMustObtain().get(index)) instanceof ItemStack) {
                    screen.addWidgetToScreen(new ItemStackWidget((ItemStack)obj, x + 8 + side * 144, y, completion.get(index)));
                } else if (obj instanceof ResourceLocation) {
                    screen.addWidgetToScreen(new ItemTagWidget((ResourceLocation)obj, x + 8 + side * 144, y, completion.get(index)));
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
        if (!this.stage.getMustCraft().isEmpty()) {
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            completion = this.stage.getCraftRequirementCompletion((Player)mc.f_91074_);
            for (index = 0; index < this.stage.getMustCraft().size(); ++index) {
                if (index > 0 && index % 7 == 0) {
                    x = startX;
                    y += 18;
                }
                if ((obj = this.stage.getMustCraft().get(index)) instanceof ItemStack) {
                    screen.addWidgetToScreen(new ItemStackWidget((ItemStack)obj, x + 8 + side * 144, y, completion.get(index)));
                } else if (obj instanceof ResourceLocation) {
                    screen.addWidgetToScreen(new ItemTagWidget((ResourceLocation)obj, x + 8 + side * 144, y, completion.get(index)));
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
        if (!this.stage.getRequiredKnowledge().isEmpty()) {
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            completion = this.stage.getKnowledgeRequirementCompletion((Player)mc.f_91074_);
            for (index = 0; index < this.stage.getRequiredKnowledge().size(); ++index) {
                if (index > 0 && index % 7 == 0) {
                    x = startX;
                    y += 18;
                }
                Knowledge know = this.stage.getRequiredKnowledge().get(index);
                screen.addWidgetToScreen(new KnowledgeWidget(know, x + 8 + side * 144, y, completion.get(index)));
                x += 18;
            }
            x = startX;
            y += 18;
        }
        if (!this.stage.getRequiredResearch().isEmpty()) {
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            completion = this.stage.getResearchRequirementCompletion((Player)mc.f_91074_);
            for (index = 0; index < this.stage.getRequiredResearch().getKeys().size(); ++index) {
                if (index > 0 && index % 7 == 0) {
                    x = startX;
                    y += 18;
                }
                SimpleResearchKey key = this.stage.getRequiredResearch().getKeys().get(index);
                screen.addWidgetToScreen(new ResearchWidget(key, x + 8 + side * 144, y, completion.get(index), this.stage.getHints().contains(key)));
                x += 18;
            }
            x = startX;
            y += 18;
        }
        y = startY + 141;
        if (screen.isProgressing()) {
            text = Component.m_237115_((String)"grimoire.primalmagick.completing_text");
            screen.addWidgetToScreen(new InactiveWidget(startX + 16 + side * 136, y, 119, 20, (Component)text));
        } else if (this.stage.arePrerequisitesMet((Player)mc.f_91074_)) {
            text = Component.m_237115_((String)"grimoire.primalmagick.complete_button");
            screen.addWidgetToScreen(new ProgressButton(this.stage, startX + 16 + side * 136, y, (Component)text, screen));
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        MutableComponent leadComponent;
        this.renderTitle(guiGraphics, side, x, y, mouseX, mouseY, null);
        y += 53;
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (!this.stage.getMustObtain().isEmpty()) {
            leadComponent = Component.m_237115_((String)"grimoire.primalmagick.must_obtain_header").m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(mc.f_91062_, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            y += 18 * (1 + this.stage.getMustObtain().size() / 7);
        }
        if (!this.stage.getMustCraft().isEmpty()) {
            leadComponent = Component.m_237115_((String)"grimoire.primalmagick.must_craft_header").m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(mc.f_91062_, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            y += 18 * (1 + this.stage.getMustCraft().size() / 7);
        }
        if (!this.stage.getRequiredKnowledge().isEmpty()) {
            leadComponent = Component.m_237115_((String)"grimoire.primalmagick.required_knowledge_header").m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(mc.f_91062_, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            y += 18 * (1 + this.stage.getRequiredKnowledge().size() / 7);
        }
        if (!this.stage.getRequiredResearch().isEmpty()) {
            leadComponent = Component.m_237115_((String)"grimoire.primalmagick.required_research_header").m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(mc.f_91062_, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            y += 18 * (1 + this.stage.getRequiredResearch().getKeys().size() / 7);
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

