/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.grimoire.AbstractRecipePage;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.BlockIngredientWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IngredientWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ItemStackWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.ManaCostSummaryWidget;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.RecipeTypeWidget;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.RitualRecipe;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class RitualRecipePage
extends AbstractRecipePage {
    protected static final int ITEMS_PER_ROW = 7;
    protected RitualRecipe recipe;

    public RitualRecipePage(RitualRecipe recipe, RegistryAccess registryAccess) {
        super(registryAccess);
        this.recipe = recipe;
    }

    @Override
    protected Component getTitleText() {
        ItemStack stack = this.recipe.m_8043_(this.registryAccess);
        return stack.m_41720_().m_7626_(stack);
    }

    @Override
    protected String getRecipeTypeTranslationKey() {
        return "grimoire.primalmagick.ritual_recipe_header";
    }

    @Override
    public void initWidgets(GrimoireScreen screen, int side, int x, int y) {
        int indent = 124;
        int overlayWidth = 52;
        int deltaX = 0;
        Minecraft mc = Minecraft.m_91087_();
        ItemStack output = this.recipe.m_8043_(this.registryAccess);
        screen.addWidgetToScreen(new ItemStackWidget(output, x + 27 + side * 140 + indent / 2 - overlayWidth / 2, y += 25, false));
        if (!this.recipe.getManaCosts().isEmpty()) {
            screen.addWidgetToScreen(new ManaCostSummaryWidget(this.recipe.getManaCosts(), x + 75 + side * 140 + indent / 2 - overlayWidth / 2, y));
        }
        screen.addWidgetToScreen(new RecipeTypeWidget((Recipe<?>)this.recipe, x - 22 + side * 140 + indent / 2 - overlayWidth / 2, y, (Component)Component.m_237115_((String)this.getRecipeTypeTranslationKey())));
        y += 28;
        if (!this.recipe.m_7527_().isEmpty()) {
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            for (Ingredient ingredient : this.recipe.m_7527_()) {
                if (deltaX >= 126) {
                    deltaX = 0;
                    y += 18;
                }
                screen.addWidgetToScreen(new IngredientWidget(ingredient, x + 8 + deltaX + side * 144, y, screen));
                deltaX += 18;
            }
            deltaX = 0;
            y += 18;
            Objects.requireNonNull(mc.f_91062_);
            y += (int)(9.0f * 0.66f);
        }
        if (!this.recipe.getProps().isEmpty()) {
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            for (BlockIngredient prop : this.recipe.getProps()) {
                if (deltaX >= 126) {
                    deltaX = 0;
                    y += 18;
                }
                screen.addWidgetToScreen(new BlockIngredientWidget(prop, x + 8 + deltaX + side * 144, y));
                deltaX += 18;
            }
            deltaX = 0;
            y += 18;
            Objects.requireNonNull(mc.f_91062_);
            y += (int)(9.0f * 0.66f);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int side, int x, int y, int mouseX, int mouseY) {
        MutableComponent leadComponent;
        super.render(guiGraphics, side, x, y, mouseX, mouseY);
        y += 79;
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (!this.recipe.m_7527_().isEmpty()) {
            leadComponent = Component.m_237115_((String)"grimoire.primalmagick.ritual_offerings_header").m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(mc.f_91062_, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            y += 18 * Mth.m_14165_((double)((double)this.recipe.m_7527_().size() / 7.0));
            Objects.requireNonNull(mc.f_91062_);
            y += (int)(9.0f * 0.66f);
        }
        if (!this.recipe.getProps().isEmpty()) {
            leadComponent = Component.m_237115_((String)"grimoire.primalmagick.ritual_props_header").m_130940_(ChatFormatting.UNDERLINE);
            guiGraphics.m_280614_(mc.f_91062_, (Component)leadComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
            Objects.requireNonNull(mc.f_91062_);
            y += 9;
            y += 18 * Mth.m_14165_((double)((double)this.recipe.getProps().size() / 7.0));
            Objects.requireNonNull(mc.f_91062_);
            y += (int)(9.0f * 0.66f);
        }
        MutableComponent headerComponent = Component.m_237115_((String)"ritual.primalmagick.instability.header").m_130940_(ChatFormatting.UNDERLINE);
        int rating = Mth.m_14045_((int)(this.recipe.getInstability() / 2), (int)0, (int)5);
        MutableComponent valueComponent = Component.m_237115_((String)("ritual.primalmagick.instability.rating." + rating));
        MutableComponent lineComponent = Component.m_237110_((String)"ritual.primalmagick.instability", (Object[])new Object[]{headerComponent, valueComponent});
        guiGraphics.m_280614_(mc.f_91062_, (Component)lineComponent, x - 3 + side * 140, y - 6, Color.BLACK.getRGB(), false);
        Objects.requireNonNull(mc.f_91062_);
        y += 9;
        guiGraphics.m_280168_().m_85849_();
    }
}

