/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.hud;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.sources.Source;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemDecorator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManaStorageItemDecorator
implements IItemDecorator {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Source source;

    public ManaStorageItemDecorator(Source source) {
        this.source = source;
    }

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        stack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).filter(manaCap -> manaCap.canStore(this.source)).ifPresent(manaCap -> {
            int width = this.getBarWidth(stack, this.source);
            int color = this.getBarColor(stack, this.source);
            int xPos = xOffset + 2;
            int yPos = yOffset + 13;
            if (stack.m_150947_()) {
                guiGraphics.m_285944_(RenderType.m_286086_(), xPos, yPos - 1, xPos + 13, yPos, -16777216);
                guiGraphics.m_285944_(RenderType.m_286086_(), xPos, yPos - 1, xPos + width, yPos, color | 0xFF000000);
            } else {
                guiGraphics.m_285944_(RenderType.m_286086_(), xPos, yPos, xPos + 13, yPos + 2, -16777216);
                guiGraphics.m_285944_(RenderType.m_286086_(), xPos, yPos, xPos + width, yPos + 1, color | 0xFF000000);
            }
        });
        return false;
    }

    protected int getBarWidth(ItemStack stack, Source source) {
        return stack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).filter(manaCap -> manaCap.canStore(this.source)).map(manaCap -> Math.round((float)manaCap.getManaStored(source) * 13.0f / (float)manaCap.getMaxManaStored(source))).orElse(0);
    }

    protected int getBarColor(ItemStack stack, Source source) {
        return 2613703;
    }
}

