/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.config.Config;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class WandHudOverlay
implements IGuiOverlay {
    private static final ResourceLocation HUD_TEXTURE = PrimalMagick.resource("textures/gui/hud.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.f_92062_ && !mc.f_91074_.m_5833_() && ((Boolean)Config.SHOW_WAND_HUD.get()).booleanValue()) {
            Item item = mc.f_91074_.m_21205_().m_41720_();
            if (item instanceof IWand) {
                IWand wand = (IWand)item;
                this.renderHud(mc, guiGraphics, mc.f_91074_.m_21205_(), wand, partialTick);
            } else {
                item = mc.f_91074_.m_21206_().m_41720_();
                if (item instanceof IWand) {
                    IWand wand = (IWand)item;
                    this.renderHud(mc, guiGraphics, mc.f_91074_.m_21206_(), wand, partialTick);
                }
            }
        }
    }

    private void renderHud(Minecraft mc, GuiGraphics guiGraphics, ItemStack stack, IWand wand, float partialTick) {
        guiGraphics.m_280168_().m_85836_();
        int posY = 0;
        ResourceLocation spellIcon = wand.getActiveSpell(stack) == null ? null : wand.getActiveSpell(stack).getIcon();
        posY += this.renderSpellDisplay(guiGraphics, 0, posY, spellIcon, partialTick);
        int index = 0;
        int maxMana = wand.getMaxMana(stack);
        MutableComponent maxText = wand.getMaxManaText(stack);
        List discoveredSources = Source.SORTED_SOURCES.stream().filter(s -> s.isDiscovered((Player)mc.f_91074_)).collect(Collectors.toList());
        for (Source source : discoveredSources) {
            int curMana = wand.getMana(stack, source);
            MutableComponent curText = wand.getManaText(stack, source);
            double ratio = (double)curMana / (double)maxMana;
            MutableComponent ratioText = Component.m_237110_((String)"tooltip.primalmagick.source.mana_summary_fragment", (Object[])new Object[]{curText, maxText});
            posY += this.renderManaGauge(guiGraphics, 0, posY, (Component)ratioText, ratio, source.getColor(), ++index == discoveredSources.size(), partialTick, mc.f_91062_);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private int renderSpellDisplay(GuiGraphics guiGraphics, int x, int y, ResourceLocation spellIcon, float partialTick) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280163_(HUD_TEXTURE, x, y, 60.0f, 0.0f, 26, 26, 256, 256);
        if (spellIcon != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            guiGraphics.m_280163_(spellIcon, x + 10, y + 10, 0.0f, 0.0f, 32, 32, 32, 32);
            guiGraphics.m_280168_().m_85849_();
        }
        return 26;
    }

    private int renderManaGauge(GuiGraphics guiGraphics, int x, int y, Component text, double ratio, int color, boolean isLast, float partialTick, Font font) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280163_(HUD_TEXTURE, x, y, 0.0f, 0.0f, 59, 12, 256, 256);
        if (!isLast) {
            guiGraphics.m_280163_(HUD_TEXTURE, x + 4, y + 8, 4.0f, 12.0f, 2, 4, 256, 256);
        }
        guiGraphics.m_280246_(WandHudOverlay.getRed(color), WandHudOverlay.getGreen(color), WandHudOverlay.getBlue(color), 1.0f);
        guiGraphics.m_280163_(HUD_TEXTURE, x + 14, y + 2, 14.0f, 12.0f, (int)(40.0 * ratio), 8, 256, 256);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (Screen.m_96638_()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(61.0f, 2.0f, 0.0f);
            guiGraphics.m_280430_(font, text, x, y, Color.WHITE.getRGB());
            guiGraphics.m_280168_().m_85849_();
        }
        return 12;
    }

    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }
}

