/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;

public class WardingHudOverlay
implements IGuiOverlay {
    protected static final ResourceLocation GUI_ICONS_LOCATION = PrimalMagick.resource("textures/gui/hud.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        if (!mc.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements()) {
            int ward;
            gui.setupOverlayRenderState(true, false);
            mc.m_91307_().m_6180_("warding");
            RenderSystem.enableBlend();
            Player player = (Player)mc.m_91288_();
            LazyOptional<IPlayerWard> wardCapOpt = PrimalMagickCapabilities.getWard(player);
            int wardLast = ward = Mth.m_14167_((float)((Float)wardCapOpt.lazyMap(wardCap -> Float.valueOf(wardCap.getCurrentWard())).orElse((Object)Float.valueOf(0.0f))).floatValue());
            boolean highlight = false;
            float wardMax = ((Float)wardCapOpt.lazyMap(wardCap -> Float.valueOf(wardCap.getMaxWard())).orElse((Object)Float.valueOf(0.0f))).floatValue();
            int absorb = 0;
            int wardRows = Mth.m_14167_((float)(wardMax / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (wardRows - 2), 3);
            if (wardMax > 0.0f) {
                int left = screenWidth / 2 - 91;
                int top = screenHeight - gui.leftHeight;
                gui.leftHeight += wardRows * rowHeight;
                if (rowHeight != 10) {
                    gui.leftHeight += 10 - rowHeight;
                }
                int regen = -1;
                if (((Boolean)wardCapOpt.lazyMap(wardCap -> wardCap.isRegenerating()).orElse((Object)false)).booleanValue()) {
                    regen = gui.m_93079_() % Mth.m_14167_((float)(wardMax + 5.0f));
                }
                this.renderPentacles(gui, guiGraphics, player, left, top, rowHeight, regen, wardMax, ward, wardLast, absorb, highlight);
            }
            RenderSystem.disableBlend();
            mc.m_91307_().m_7238_();
        }
    }

    private void renderPentacles(ForgeGui gui, GuiGraphics guiGraphics, Player player, int left, int top, int rowHeight, int regen, float wardMax, int ward, int wardLast, int absorb, boolean highlight) {
        int maxHealthHearts = Mth.m_14165_((double)((double)wardMax / 2.0));
        int maxAbsorbHearts = Mth.m_14165_((double)((double)absorb / 2.0));
        for (int index = maxHealthHearts + maxAbsorbHearts - 1; index >= 0; --index) {
            int row = index / 10;
            int col = index % 10;
            int xPos = left + col * 8;
            int yPos = top - row * rowHeight;
            if (index < maxHealthHearts && index == regen) {
                yPos -= 2;
            }
            this.renderPentacle(guiGraphics, xPos, yPos, 87, 0, highlight, false);
            int doubleIndex = index * 2;
            if (highlight && doubleIndex < wardLast) {
                this.renderPentacle(guiGraphics, xPos, yPos, 96, 0, true, doubleIndex + 1 == wardLast);
            }
            if (doubleIndex >= ward) continue;
            this.renderPentacle(guiGraphics, xPos, yPos, 96, 0, false, doubleIndex + 1 == ward);
        }
    }

    private void renderPentacle(GuiGraphics guiGraphics, int xPos, int yPos, int textureX, int textureY, boolean highlight, boolean isHalf) {
        guiGraphics.m_280218_(GUI_ICONS_LOCATION, xPos, yPos, textureX + (isHalf ? 9 : 0), textureY, 9, 9);
    }
}

