/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookComponent;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeButton;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.client.gui.recipe_book.OverlayArcaneRecipeComponent;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.Recipe;

public class ArcaneRecipeBookPage {
    public static final int ITEMS_PER_PAGE = 20;
    protected final List<ArcaneRecipeButton> buttons = new ArrayList<ArcaneRecipeButton>(20);
    protected final OverlayArcaneRecipeComponent overlay = new OverlayArcaneRecipeComponent();
    protected final List<RecipeShownListener> showListeners = new ArrayList<RecipeShownListener>();
    @Nullable
    protected ArcaneRecipeButton hoveredButton;
    protected Minecraft mc;
    protected List<ArcaneRecipeCollection> recipeCollections = ImmutableList.of();
    protected StateSwitchingButton forwardButton;
    protected StateSwitchingButton backButton;
    protected int totalPages;
    protected int currentPage;
    protected boolean isLoading = true;
    protected RecipeBook vanillaBook;
    protected ArcaneRecipeBook arcaneBook;
    @Nullable
    protected Recipe<?> lastClickedRecipe;
    @Nullable
    protected ArcaneRecipeCollection lastClickedRecipeCollection;

    public ArcaneRecipeBookPage() {
        for (int index = 0; index < 20; ++index) {
            this.buttons.add(new ArcaneRecipeButton());
        }
    }

    public void init(Minecraft mc, int xPos, int yPos, ArcaneRecipeBook arcaneBook) {
        this.mc = mc;
        this.vanillaBook = mc.f_91074_.m_108631_();
        this.arcaneBook = arcaneBook;
        for (int index = 0; index < this.buttons.size(); ++index) {
            this.buttons.get(index).m_264152_(xPos + 11 + 25 * (index % 5), yPos + 31 + 25 * (index / 5));
            this.buttons.get((int)index).f_93624_ = false;
        }
        this.forwardButton = new StateSwitchingButton(xPos + 93, yPos + 137, 12, 17, false);
        this.forwardButton.m_94624_(1, 208, 13, 18, ArcaneRecipeBookComponent.RECIPE_BOOK_LOCATION);
        this.backButton = new StateSwitchingButton(xPos + 38, yPos + 137, 12, 17, true);
        this.backButton.m_94624_(1, 208, 13, 18, ArcaneRecipeBookComponent.RECIPE_BOOK_LOCATION);
        this.updateArrowButtons();
    }

    public void addListener(ArcaneRecipeBookComponent component) {
        this.showListeners.remove(component);
        this.showListeners.add(component);
    }

    public void updateCollections(List<ArcaneRecipeCollection> collectionList, boolean resetPage) {
        this.recipeCollections = collectionList;
        this.totalPages = (int)Math.ceil((double)collectionList.size() / 20.0);
        if (this.totalPages <= this.currentPage || resetPage) {
            this.currentPage = 0;
        }
        this.isLoading = false;
        this.updateButtonsForPage();
    }

    protected void updateButtonsForPage() {
        int recipesPast = 20 * this.currentPage;
        for (int index = 0; index < this.buttons.size(); ++index) {
            ArcaneRecipeButton button = this.buttons.get(index);
            if (recipesPast + index < this.recipeCollections.size()) {
                ArcaneRecipeCollection collection = this.recipeCollections.get(recipesPast + index);
                button.init(collection, this);
                button.f_93624_ = true;
                continue;
            }
            button.f_93624_ = false;
        }
        this.updateArrowButtons();
    }

    protected void updateArrowButtons() {
        this.forwardButton.f_93624_ = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.f_93624_ = this.totalPages > 1 && this.currentPage > 0;
    }

    public void render(GuiGraphics guiGraphics, int parentX, int parentY, int mouseX, int mouseY, float partialTicks) {
        if (this.totalPages > 1) {
            String str = this.currentPage + 1 + "/" + this.totalPages;
            int width = this.mc.f_91062_.m_92895_(str);
            guiGraphics.m_280488_(this.mc.f_91062_, str, parentX - width / 2 + 73, parentY + 141, -1);
        }
        if (this.isLoading) {
            MutableComponent loadingComponent = Component.m_237115_((String)"label.primalmagick.recipe_book.loading");
            int loadingWidth = this.mc.f_91062_.m_92852_((FormattedText)loadingComponent);
            guiGraphics.m_280430_(this.mc.f_91062_, (Component)loadingComponent, parentX - loadingWidth / 2 + 73, parentY + 77, -1);
        }
        this.hoveredButton = null;
        for (ArcaneRecipeButton button : this.buttons) {
            button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (!button.f_93624_ || !button.m_198029_()) continue;
            this.hoveredButton = button;
        }
        this.backButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.forwardButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.overlay.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.mc.f_91080_ != null && this.hoveredButton != null && !this.overlay.isVisible()) {
            guiGraphics.renderComponentTooltip(this.mc.f_91062_, this.hoveredButton.getTooltipText(this.mc.f_91080_), mouseX, mouseY, this.hoveredButton.getRecipe().m_8043_(this.mc.f_91073_.m_9598_()));
        }
    }

    @Nullable
    public Recipe<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    @Nullable
    public ArcaneRecipeCollection getLastClickedRecipeCollection() {
        return this.lastClickedRecipeCollection;
    }

    public void setInvisible() {
        this.overlay.setVisible(false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, int xPos, int yPos, int width, int height) {
        this.lastClickedRecipe = null;
        this.lastClickedRecipeCollection = null;
        if (this.overlay.isVisible()) {
            if (this.overlay.m_6375_(mouseX, mouseY, button)) {
                this.lastClickedRecipe = this.overlay.lastRecipeClicked;
                this.lastClickedRecipeCollection = this.overlay.getRecipeCollection();
            } else {
                this.overlay.setVisible(false);
            }
            return true;
        }
        if (this.forwardButton.m_6375_(mouseX, mouseY, button)) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.m_6375_(mouseX, mouseY, button)) {
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        for (ArcaneRecipeButton recipeButton : this.buttons) {
            if (!recipeButton.m_6375_(mouseX, mouseY, button)) continue;
            if (button == 0) {
                this.lastClickedRecipe = recipeButton.getRecipe();
                this.lastClickedRecipeCollection = recipeButton.getCollection();
            } else if (button == 1 && !this.overlay.isVisible() && !recipeButton.isOnlyOption()) {
                this.overlay.init(this.mc, recipeButton.getCollection(), this.arcaneBook, recipeButton.m_252754_(), recipeButton.m_252907_(), xPos + width / 2, yPos + 13 + height / 2, recipeButton.m_5711_());
            }
            return true;
        }
        return false;
    }

    public void recipesShown(List<Recipe<?>> recipes) {
        for (RecipeShownListener listener : this.showListeners) {
            listener.m_7262_(recipes);
        }
    }

    public Minecraft getMinecraft() {
        return this.mc;
    }

    public RecipeBook getVanillaRecipeBook() {
        return this.vanillaBook;
    }

    public ArcaneRecipeBook getArcaneRecipeBook() {
        return this.arcaneBook;
    }

    public void listButtons(Consumer<AbstractWidget> consumer) {
        consumer.accept((AbstractWidget)this.forwardButton);
        consumer.accept((AbstractWidget)this.backButton);
        this.buttons.forEach(consumer);
    }
}

