/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookComponent;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.client.recipe_book.ArcaneRecipeBookCategories;
import com.verdantartifice.primalmagick.client.recipe_book.ClientArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class ArcaneRecipeBookTabButton
extends StateSwitchingButton {
    protected static final float ANIMATION_TIME = 15.0f;
    protected final ArcaneRecipeBookCategories category;
    protected float animationTime;

    public ArcaneRecipeBookTabButton(ArcaneRecipeBookCategories category) {
        super(0, 0, 35, 27, false);
        this.category = category;
        this.m_94624_(153, 2, 35, 0, ArcaneRecipeBookComponent.RECIPE_BOOK_LOCATION);
    }

    public void startAnimation(Minecraft mc, ClientRecipeBook vanillaBook, ClientArcaneRecipeBook arcaneBook) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(arcaneBook.getCollection(this.category));
        builder.addAll((Iterable)vanillaBook.m_90623_(this.category.getVanillaCategory()).stream().map(ArcaneRecipeCollection::new).collect(Collectors.toList()));
        ImmutableList list = builder.build();
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof IArcaneRecipeBookMenu) {
            IArcaneRecipeBookMenu recipeMenu = (IArcaneRecipeBookMenu)abstractContainerMenu;
            for (ArcaneRecipeCollection recipeCollection : list) {
                for (Recipe<?> recipe : recipeCollection.getRecipes(arcaneBook.getData().isFiltering(recipeMenu.getRecipeBookType()))) {
                    if (!arcaneBook.getData().willHighlight(recipe) && !vanillaBook.m_12717_(recipe)) continue;
                    this.animationTime = 15.0f;
                    return;
                }
            }
        }
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_94632_, int p_94633_, float p_94634_) {
        if (this.animationTime > 0.0f) {
            float f = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)(this.m_252754_() + 8), (double)(this.m_252907_() + 12), 0.0);
            guiGraphics.m_280168_().m_85841_(1.0f, f, 1.0f);
            guiGraphics.m_280168_().m_85837_((double)(-(this.m_252754_() + 8)), (double)(-(this.m_252907_() + 12)), 0.0);
        }
        RenderSystem.disableDepthTest();
        int texX = this.f_94610_;
        int texY = this.f_94611_;
        if (this.f_94609_) {
            texX += this.f_94612_;
        }
        if (this.m_198029_()) {
            texY += this.f_94613_;
        }
        int localX = this.m_252754_();
        if (this.f_94609_) {
            localX -= 2;
        }
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(this.f_94608_, localX, this.m_252907_(), texX, texY, this.f_93618_, this.f_93619_);
        RenderSystem.enableDepthTest();
        this.renderIcon(guiGraphics);
        if (this.animationTime > 0.0f) {
            guiGraphics.m_280168_().m_85849_();
            this.animationTime -= p_94634_;
        }
    }

    protected void renderIcon(GuiGraphics guiGraphics) {
        int dx;
        List<ItemStack> list = this.category.getIconItems();
        int n = dx = this.f_94609_ ? -2 : 0;
        if (list.size() == 1) {
            guiGraphics.m_280203_(list.get(0), this.m_252754_() + 9 + dx, this.m_252907_() + 5);
        } else if (list.size() == 2) {
            guiGraphics.m_280203_(list.get(0), this.m_252754_() + 3 + dx, this.m_252907_() + 5);
            guiGraphics.m_280203_(list.get(1), this.m_252754_() + 14 + dx, this.m_252907_() + 5);
        }
    }

    public ArcaneRecipeBookCategories getCategory() {
        return this.category;
    }

    public boolean updateVisibility(ClientRecipeBook vanillaBook, ClientArcaneRecipeBook arcaneBook) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(arcaneBook.getCollection(this.category));
        builder.addAll((Iterable)vanillaBook.m_90623_(this.category.getVanillaCategory()).stream().map(ArcaneRecipeCollection::new).collect(Collectors.toList()));
        ImmutableList list = builder.build();
        this.f_93624_ = false;
        for (ArcaneRecipeCollection collection : list) {
            if (!collection.hasKnownRecipes() || !collection.hasFitting()) continue;
            this.f_93624_ = true;
            break;
        }
        return this.f_93624_;
    }
}

