/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeBookPage;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class ArcaneRecipeButton
extends AbstractWidget {
    protected static final ResourceLocation RECIPE_BOOK_LOCATION = new ResourceLocation("textures/gui/recipe_book.png");
    protected static final float ANIMATION_TIME = 15.0f;
    protected static final int BACKGROUND_SIZE = 25;
    public static final int TICKS_TO_SWAP = 30;
    protected static final Component MORE_RECIPES_TOOLTIP = Component.m_237115_((String)"gui.recipebook.moreRecipes");
    protected IArcaneRecipeBookMenu<?> menu;
    protected ArcaneRecipeBook book;
    protected ArcaneRecipeCollection collection;
    protected float time;
    protected float animationTime;
    protected int currentIndex;

    public ArcaneRecipeButton() {
        super(0, 0, 25, 25, (Component)Component.m_237119_());
    }

    public void init(ArcaneRecipeCollection recipeCollection, ArcaneRecipeBookPage page) {
        IArcaneRecipeBookMenu recipeBookMenu;
        Minecraft mc = page.getMinecraft();
        this.collection = recipeCollection;
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        this.menu = abstractContainerMenu instanceof IArcaneRecipeBookMenu ? (recipeBookMenu = (IArcaneRecipeBookMenu)abstractContainerMenu) : null;
        this.book = page.getArcaneRecipeBook();
        List<Recipe<?>> list = this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType()));
        for (Recipe recipe : list) {
            if (!this.book.willHighlight(recipe)) continue;
            page.recipesShown(list);
            this.animationTime = 15.0f;
            break;
        }
    }

    public ArcaneRecipeCollection getCollection() {
        return this.collection;
    }

    public void m_264152_(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_93677_, int p_93678_, float p_93679_) {
        boolean animating;
        if (!Screen.m_96637_()) {
            this.time += p_93679_;
        }
        Minecraft mc = Minecraft.m_91087_();
        int texX = 29;
        if (!this.collection.hasCraftable()) {
            texX += 25;
        }
        int texY = 206;
        if (this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType())).size() > 1) {
            texY += 25;
        }
        boolean bl = animating = this.animationTime > 0.0f;
        if (animating) {
            float scale = 1.0f + 0.1f * (float)Math.sin(this.animationTime / 15.0f * (float)Math.PI);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)(this.m_252754_() + 8), (double)(this.m_252907_() + 12), 0.0);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280168_().m_85837_((double)(-(this.m_252754_() + 8)), (double)(-(this.m_252907_() + 12)), 0.0);
            this.animationTime -= p_93679_;
        }
        guiGraphics.m_280218_(RECIPE_BOOK_LOCATION, this.m_252754_(), this.m_252907_(), texX, texY, this.f_93618_, this.f_93619_);
        List<Recipe<?>> recipeList = this.getOrderedRecipes();
        this.currentIndex = Mth.m_14143_((float)(this.time / 30.0f)) % recipeList.size();
        ItemStack stack = recipeList.get(this.currentIndex).m_8043_(mc.f_91073_.m_9598_());
        int k = 4;
        if (this.collection.hasSingleResultItem() && this.getOrderedRecipes().size() > 1) {
            guiGraphics.m_280064_(stack, this.m_252754_() + k + 1, this.m_252907_() + k + 1, 0, 10);
            --k;
        }
        guiGraphics.m_280203_(stack, this.m_252754_() + k, this.m_252907_() + k);
        if (animating) {
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected List<Recipe<?>> getOrderedRecipes() {
        List<Recipe<?>> retVal = this.collection.getDisplayRecipes(true);
        if (!this.book.isFiltering(this.menu.getRecipeBookType())) {
            retVal.addAll(this.collection.getDisplayRecipes(false));
        }
        return retVal;
    }

    public boolean isOnlyOption() {
        return this.getOrderedRecipes().size() == 1;
    }

    public Recipe<?> getRecipe() {
        return this.getOrderedRecipes().get(this.currentIndex);
    }

    public List<Component> getTooltipText(Screen screen) {
        Minecraft mc = screen.getMinecraft();
        ItemStack stack = this.getRecipe().m_8043_(mc.f_91073_.m_9598_());
        ArrayList<Component> retVal = new ArrayList<Component>(Screen.m_280152_((Minecraft)mc, (ItemStack)stack));
        if (this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType())).size() > 1) {
            retVal.add(MORE_RECIPES_TOOLTIP);
        }
        return retVal;
    }

    public void m_168797_(NarrationElementOutput output) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = this.getRecipe().m_8043_(mc.f_91073_.m_9598_());
        output.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237110_((String)"narration.recipe", (Object[])new Object[]{stack.m_41786_()}));
        if (this.collection.getRecipes(this.book.isFiltering(this.menu.getRecipeBookType())).size() > 1) {
            output.m_169149_(NarratedElementType.USAGE, new Component[]{Component.m_237115_((String)"narration.button.usage.hovered"), Component.m_237115_((String)"narration.recipe.usage.more")});
        } else {
            output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.button.usage.hovered"));
        }
    }

    public int m_5711_() {
        return 25;
    }

    protected boolean m_7972_(int value) {
        return value == 0 || value == 1;
    }
}

