/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.recipe_book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class OverlayArcaneRecipeComponent
implements Renderable,
GuiEventListener {
    protected static final ResourceLocation RECIPE_BOOK_LOCATION = new ResourceLocation("textures/gui/recipe_book.png");
    protected static final int MAX_ROW = 4;
    protected static final int MAX_ROW_LARGE = 5;
    protected static final float ITEM_RENDER_SCALE = 0.375f;
    protected final List<OverlayArcaneRecipeButton> recipeButtons = new ArrayList<OverlayArcaneRecipeButton>();
    protected boolean isVisible;
    protected int x;
    protected int y;
    protected Minecraft mc;
    protected ArcaneRecipeCollection collection;
    @Nullable
    protected Recipe<?> lastRecipeClicked;
    protected float time;
    protected boolean useFurnaceStyle;

    public void init(Minecraft mc, ArcaneRecipeCollection recipeCollection, ArcaneRecipeBook book, int xPos, int yPos, int dx, int dy, float parentWidth) {
        float f5;
        float f4;
        float f3;
        float f2;
        this.mc = mc;
        this.collection = recipeCollection;
        boolean isFiltering = false;
        AbstractContainerMenu abstractContainerMenu = mc.f_91074_.f_36096_;
        if (abstractContainerMenu instanceof IArcaneRecipeBookMenu) {
            IArcaneRecipeBookMenu arcaneMenu = (IArcaneRecipeBookMenu)abstractContainerMenu;
            this.useFurnaceStyle = arcaneMenu.isSingleIngredientMenu();
            isFiltering = book.isFiltering(arcaneMenu.getRecipeBookType());
        } else {
            this.useFurnaceStyle = false;
        }
        List<Recipe<?>> visibleRecipes = this.collection.getDisplayRecipes(true);
        List invisibleRecipes = isFiltering ? Collections.emptyList() : this.collection.getDisplayRecipes(false);
        int visibleSize = visibleRecipes.size();
        int totalSize = visibleSize + invisibleRecipes.size();
        int maxRowSize = totalSize <= 16 ? 4 : 5;
        int rowCount = Mth.m_14165_((double)((float)totalSize / (float)maxRowSize));
        this.x = xPos;
        this.y = yPos;
        float f = this.x + Math.min(totalSize, maxRowSize) * 25;
        float f1 = dx + 50;
        if (f > f1) {
            this.x = (int)((float)this.x - parentWidth * (float)((int)((f - f1) / parentWidth)));
        }
        if ((f2 = (float)(this.y + rowCount * 25)) > (f3 = (float)(dy + 50))) {
            this.y = (int)((float)this.y - parentWidth * (float)Mth.m_14167_((float)((f2 - f3) / parentWidth)));
        }
        if ((f4 = (float)this.y) < (f5 = (float)(dy - 100))) {
            this.y = (int)((float)this.y - parentWidth * (float)Mth.m_14167_((float)((f4 - f5) / parentWidth)));
        }
        this.isVisible = true;
        this.recipeButtons.clear();
        for (int index = 0; index < totalSize; ++index) {
            boolean isVisible = index < visibleSize;
            Recipe recipe = isVisible ? visibleRecipes.get(index) : (Recipe)invisibleRecipes.get(index - visibleSize);
            int slotX = this.x + 4 + 25 * (index % maxRowSize);
            int slotY = this.y + 5 + 25 * (index / maxRowSize);
            if (this.useFurnaceStyle) {
                this.recipeButtons.add(new OverlayArcaneSingleIngredientRecipeButton(slotX, slotY, recipe, isVisible));
                continue;
            }
            this.recipeButtons.add(new OverlayArcaneRecipeButton(slotX, slotY, recipe, isVisible));
        }
        this.lastRecipeClicked = null;
    }

    public ArcaneRecipeCollection getRecipeCollection() {
        return this.collection;
    }

    @Nullable
    public Recipe<?> getLastRecipeClicked() {
        return this.lastRecipeClicked;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        for (OverlayArcaneRecipeButton recipeButton : this.recipeButtons) {
            if (!recipeButton.m_6375_(mouseX, mouseY, button)) continue;
            this.lastRecipeClicked = recipeButton.recipe;
            return true;
        }
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible) {
            this.time += partialTicks;
            RenderSystem.enableBlend();
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(0.0, 0.0, 170.0);
            int maxRowSize = this.recipeButtons.size() <= 16 ? 4 : 5;
            int colCount = Math.min(this.recipeButtons.size(), maxRowSize);
            int rowCount = Mth.m_14167_((float)((float)this.recipeButtons.size() / (float)maxRowSize));
            guiGraphics.m_280260_(RECIPE_BOOK_LOCATION, this.x, this.y, colCount * 25 + 8, rowCount * 25 + 8, 4, 32, 32, 82, 208);
            RenderSystem.disableBlend();
            for (OverlayArcaneRecipeButton recipeButton : this.recipeButtons) {
                recipeButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void m_93692_(boolean p_265728_) {
    }

    public boolean m_93696_() {
        return false;
    }

    protected class OverlayArcaneSingleIngredientRecipeButton
    extends OverlayArcaneRecipeButton {
        public OverlayArcaneSingleIngredientRecipeButton(int xPos, int yPos, Recipe<?> recipe, boolean isCraftable) {
            super(xPos, yPos, recipe, isCraftable);
        }

        @Override
        protected void calculateIngredientsPositions(Recipe<?> recipe) {
            ItemStack[] aitemstack = ((Ingredient)recipe.m_7527_().get(0)).m_43908_();
            this.ingredientPos.add(new OverlayArcaneRecipeButton.Pos(10, 10, aitemstack));
        }
    }

    protected class OverlayArcaneRecipeButton
    extends AbstractWidget
    implements PlaceRecipe<Ingredient> {
        protected final Recipe<?> recipe;
        protected final boolean isCraftable;
        protected final List<Pos> ingredientPos;

        public OverlayArcaneRecipeButton(int xPos, int yPos, Recipe<?> recipe, boolean isCraftable) {
            super(xPos, yPos, 200, 20, (Component)Component.m_237119_());
            this.ingredientPos = new ArrayList<Pos>();
            this.f_93618_ = 24;
            this.f_93619_ = 24;
            this.recipe = recipe;
            this.isCraftable = isCraftable;
            this.calculateIngredientsPositions(recipe);
        }

        protected void calculateIngredientsPositions(Recipe<?> recipe) {
            this.m_135408_(3, 3, -1, recipe, recipe.m_7527_().iterator(), 0);
        }

        public void m_168797_(NarrationElementOutput output) {
            this.m_168802_(output);
        }

        public void m_5817_(Iterator<Ingredient> ingredientIterator, int p_135416_, int p_135417_, int p_135418_, int p_135419_) {
            ItemStack[] stackArray = ingredientIterator.next().m_43908_();
            if (stackArray.length != 0) {
                this.ingredientPos.add(new Pos(3 + p_135419_ * 7, 3 + p_135418_ * 7, stackArray));
            }
        }

        public void m_87963_(GuiGraphics guiGraphics, int p_93677_, int p_93678_, float p_93679_) {
            int texY;
            int texX = 152;
            if (!this.isCraftable) {
                texX += 26;
            }
            int n = texY = OverlayArcaneRecipeComponent.this.useFurnaceStyle ? 130 : 78;
            if (this.m_198029_()) {
                texY += 26;
            }
            guiGraphics.m_280218_(RECIPE_BOOK_LOCATION, this.m_252754_(), this.m_252907_(), texX, texY, this.f_93618_, this.f_93619_);
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_85837_((double)(this.m_252754_() + 2), (double)(this.m_252907_() + 2), 125.0);
            for (Pos pos : this.ingredientPos) {
                modelViewStack.m_85836_();
                modelViewStack.m_85837_((double)pos.x, (double)pos.y, 0.0);
                modelViewStack.m_85841_(0.375f, 0.375f, 1.0f);
                modelViewStack.m_85837_(-8.0, -8.0, 0.0);
                RenderSystem.applyModelViewMatrix();
                guiGraphics.m_280480_(pos.ingredients[Mth.m_14143_((float)(OverlayArcaneRecipeComponent.this.time / 30.0f)) % pos.ingredients.length], 0, 0);
                modelViewStack.m_85849_();
            }
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        protected class Pos {
            public final ItemStack[] ingredients;
            public final int x;
            public final int y;

            public Pos(int x, int y, ItemStack[] ingredients) {
                this.ingredients = ingredients;
                this.x = x;
                this.y = y;
            }
        }
    }
}

