/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class EssenceCaskWidget
extends AbstractWidget {
    protected final int index;
    protected final EssenceType essenceType;
    protected final Source source;
    protected int amount;
    protected final BiConsumer<EssenceCaskWidget, Integer> onClick;

    public EssenceCaskWidget(int index, EssenceType type, Source source, int amount, int xIn, int yIn, BiConsumer<EssenceCaskWidget, Integer> onClick) {
        super(xIn, yIn, 16, 16, (Component)Component.m_237119_());
        this.index = index;
        this.essenceType = type;
        this.source = source;
        this.amount = amount;
        this.onClick = onClick;
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = EssenceItem.getEssence(this.essenceType, this.source);
        List lines = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        lines.add(Component.m_237115_((String)"label.primalmagick.essence_cask.left_click").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        lines.add(Component.m_237115_((String)"label.primalmagick.essence_cask.right_click").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178391_((Collection)lines)));
    }

    public int getIndex() {
        return this.index;
    }

    public EssenceType getEssenceType() {
        return this.essenceType;
    }

    public Source getSource() {
        return this.source;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack tempStack = EssenceItem.getEssence(this.essenceType, this.source);
        GuiUtils.renderItemStack(guiGraphics, tempStack, this.m_252754_(), this.m_252907_(), this.m_6035_().getString(), true);
        MutableComponent amountText = Component.m_237113_((String)Integer.toString(this.amount));
        int width = mc.f_91062_.m_92852_((FormattedText)amountText);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 16 - width / 2), (float)(this.m_252907_() + 12), 200.0f);
        guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        guiGraphics.m_280430_(mc.f_91062_, (Component)amountText, 0, 0, this.amount > 0 ? Color.WHITE.getRGB() : Color.RED.getRGB());
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickButton) {
        if (this.f_93623_ && this.f_93624_ && this.m_93680_(mouseX, mouseY)) {
            this.onClick.accept(this, clickButton);
            return true;
        }
        return false;
    }

    public void m_168797_(NarrationElementOutput output) {
    }
}

