/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.client.gui.widgets.AbstractSourceWidget;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ManaCostWidget
extends AbstractSourceWidget {
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    protected final Supplier<ItemStack> wandStackSupplier;
    protected final Player player;

    public ManaCostWidget(Source source, int amount, int xIn, int yIn, Supplier<ItemStack> wandStackSupplier, Player player) {
        super(source, amount, xIn, yIn);
        this.wandStackSupplier = wandStackSupplier;
        this.player = player;
    }

    protected double getCostModifier() {
        double d;
        ItemStack wandStack = this.wandStackSupplier.get();
        Item item = wandStack.m_41720_();
        if (item instanceof IWand) {
            IWand wand = (IWand)item;
            d = wand.getTotalCostModifier(wandStack, this.player, this.source);
        } else {
            d = 1.0;
        }
        return d;
    }

    protected double getModifiedAmount() {
        return (double)this.getAmount() * this.getCostModifier();
    }

    @Override
    protected String getAmountString() {
        return MANA_FORMATTER.format(this.getModifiedAmount());
    }

    @Override
    protected int getAmountStringColor() {
        double costModifier = this.getCostModifier();
        if (costModifier > 1.0) {
            return Color.RED.getRGB();
        }
        if (costModifier < 1.0) {
            return Color.GREEN.getRGB();
        }
        return super.getAmountStringColor();
    }

    @Override
    protected List<Component> getTooltipLines() {
        int baseCost = this.getAmount();
        double modifiedCost = this.getModifiedAmount();
        double costDelta = Math.abs(modifiedCost - (double)baseCost);
        ImmutableList retVal = modifiedCost > (double)baseCost ? ImmutableList.of((Object)Component.m_237110_((String)"label.primalmagick.crafting.mana.base", (Object[])new Object[]{baseCost}), (Object)Component.m_237110_((String)"label.primalmagick.crafting.mana.penalty", (Object[])new Object[]{Component.m_237113_((String)MANA_FORMATTER.format(costDelta)).m_130940_(ChatFormatting.RED)}), (Object)Component.m_237110_((String)"label.primalmagick.crafting.mana.modified", (Object[])new Object[]{MANA_FORMATTER.format(modifiedCost), this.getSourceText()})) : (modifiedCost < (double)baseCost ? ImmutableList.of((Object)Component.m_237110_((String)"label.primalmagick.crafting.mana.base", (Object[])new Object[]{baseCost}), (Object)Component.m_237110_((String)"label.primalmagick.crafting.mana.bonus", (Object[])new Object[]{Component.m_237113_((String)MANA_FORMATTER.format(costDelta)).m_130940_(ChatFormatting.GREEN)}), (Object)Component.m_237110_((String)"label.primalmagick.crafting.mana.modified", (Object[])new Object[]{MANA_FORMATTER.format(modifiedCost), this.getSourceText()})) : Collections.singletonList(Component.m_237110_((String)"label.primalmagick.crafting.mana", (Object[])new Object[]{baseCost, this.getSourceText()})));
        return retVal;
    }
}

