/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Collections;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ManaGaugeWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/mana_gauge.png");
    protected static final DecimalFormat MANA_FORMATTER = new DecimalFormat("#######.##");
    protected final Source source;
    protected int maxAmount;
    protected int curAmount;

    public ManaGaugeWidget(int xPos, int yPos, Source source, int curAmount, int maxAmount) {
        super(xPos, yPos, 12, 52, (Component)Component.m_237119_());
        this.source = source;
        this.curAmount = curAmount;
        this.maxAmount = maxAmount;
    }

    public void m_264152_(int newX, int newY) {
        this.m_252865_(newX);
        this.m_253211_(newY);
    }

    public void setCurrentMana(int amount) {
        this.curAmount = amount;
    }

    public void setMaxMana(int amount) {
        this.maxAmount = amount;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE, 0, 0, 12, 0, this.f_93618_, this.f_93619_);
        int mana = this.getScaledMana();
        Color manaColor = new Color(this.source.getColor());
        guiGraphics.m_280246_((float)manaColor.getRed() / 255.0f, (float)manaColor.getGreen() / 255.0f, (float)manaColor.getBlue() / 255.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE, 1, 51 - mana, 1, 1, 10, mana);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(TEXTURE, 0, 0, 24, 0, this.f_93618_, this.f_93619_);
        guiGraphics.m_280168_().m_85849_();
        if (this.m_198029_()) {
            Component sourceText = this.source.getNameText();
            MutableComponent labelText = Component.m_237110_((String)"tooltip.primalmagick.source.mana_gauge", (Object[])new Object[]{sourceText, this.getManaText(), this.getMaxManaText()});
            GuiUtils.renderCustomTooltip(guiGraphics, Collections.singletonList(labelText), this.m_252754_(), this.m_252907_());
        }
    }

    protected int getScaledMana() {
        if (this.maxAmount == -1) {
            return 50;
        }
        if (this.maxAmount != 0 && this.curAmount != 0) {
            return this.curAmount * 50 / this.maxAmount;
        }
        return 0;
    }

    protected MutableComponent getManaText() {
        if (this.maxAmount == -1) {
            return Component.m_237113_((String)Character.toString('\u221e'));
        }
        return Component.m_237113_((String)MANA_FORMATTER.format((double)this.curAmount / 100.0));
    }

    public MutableComponent getMaxManaText() {
        if (this.maxAmount == -1) {
            return Component.m_237113_((String)Character.toString('\u221e'));
        }
        return Component.m_237113_((String)MANA_FORMATTER.format((double)this.maxAmount / 100.0));
    }

    public void m_168797_(NarrationElementOutput output) {
    }
}

