/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractTopicButton;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IndexIconFactory;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncProgressPacket;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncResearchFlagsPacket;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.topics.EntryResearchTopic;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class EntryButton
extends AbstractTopicButton {
    protected ResearchEntry entry;

    public EntryButton(int x, int y, Component text, GrimoireScreen screen, ResearchEntry entry, boolean showIcon) {
        super(x, y, 123, 12, text, screen, showIcon ? IndexIconFactory.fromEntryIcon(entry.getIcon(), false) : null, new Handler());
        this.entry = entry;
    }

    public ResearchEntry getEntry() {
        return this.entry;
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void m_93750_(Button button) {
            if (button instanceof EntryButton) {
                EntryButton geb = (EntryButton)button;
                Minecraft mc = Minecraft.m_91087_();
                geb.getScreen().pushCurrentHistoryTopic();
                geb.getScreen().setTopic(new EntryResearchTopic(geb.getEntry(), 0));
                if (geb.getEntry().getKey().isKnownBy((Player)mc.f_91074_)) {
                    PrimalMagickCapabilities.getKnowledge((Player)mc.f_91074_).ifPresent(knowledge -> {
                        knowledge.removeResearchFlag(geb.getEntry().getKey(), IPlayerKnowledge.ResearchFlag.NEW);
                        knowledge.removeResearchFlag(geb.getEntry().getKey(), IPlayerKnowledge.ResearchFlag.UPDATED);
                        PacketHandler.sendToServer(new SyncResearchFlagsPacket((Player)mc.f_91074_, geb.getEntry().getKey()));
                    });
                } else {
                    PacketHandler.sendToServer(new SyncProgressPacket(geb.getEntry().getKey(), true, false, true, true));
                }
                geb.getScreen().getMinecraft().m_91152_((Screen)new GrimoireScreen());
            }
        }
    }
}

