/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.verdantartifice.primalmagick.client.gui.GrimoireScreen;
import com.verdantartifice.primalmagick.client.util.GuiUtils;
import com.verdantartifice.primalmagick.common.research.topics.OtherResearchTopic;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientWidget
extends Button {
    protected Ingredient ingredient;
    protected GrimoireScreen screen;

    public IngredientWidget(@Nullable Ingredient ingredient, int x, int y, GrimoireScreen screen) {
        super(Button.m_253074_((Component)Component.m_237119_(), (Button.OnPress)new Handler()).m_252987_(x, y, 16, 16));
        this.ingredient = ingredient;
        this.screen = screen;
    }

    public GrimoireScreen getScreen() {
        return this.screen;
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        ItemStack toDisplay = this.getDisplayStack();
        if (!toDisplay.m_41619_()) {
            GuiUtils.renderItemStack(guiGraphics, toDisplay, this.m_252754_(), this.m_252907_(), this.m_6035_().getString(), false);
            this.m_93692_(false);
            Minecraft mc = Minecraft.m_91087_();
            this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178391_((Collection)toDisplay.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_)))));
        }
    }

    protected boolean m_7972_(int p_93652_) {
        ItemStack displayStack = this.getDisplayStack();
        return super.m_7972_(p_93652_) && !displayStack.m_41619_() && this.screen.isIndexKey(displayStack.m_41786_().getString());
    }

    public void m_7435_(SoundManager handler) {
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)SoundsPM.PAGE.get()), (float)1.0f, (float)1.0f));
    }

    @Nonnull
    protected ItemStack getDisplayStack() {
        ItemStack[] matching;
        if (this.ingredient != null && (matching = this.ingredient.m_43908_()) != null && matching.length > 0) {
            int index = (int)(System.currentTimeMillis() / 1000L % (long)matching.length);
            return matching[index];
        }
        return ItemStack.f_41583_;
    }

    private static class Handler
    implements Button.OnPress {
        private Handler() {
        }

        public void m_93750_(Button button) {
            if (button instanceof IngredientWidget) {
                IngredientWidget iw = (IngredientWidget)button;
                iw.getScreen().gotoTopic(new OtherResearchTopic(iw.getDisplayStack().m_41786_().getString(), 0));
            }
        }
    }
}

