/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.grimoire;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.AbstractIndexIcon;
import com.verdantartifice.primalmagick.client.gui.widgets.grimoire.IndexIconFactory;
import com.verdantartifice.primalmagick.common.research.ResearchDiscipline;
import com.verdantartifice.primalmagick.common.research.ResearchDisciplines;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;

public class UpcomingEntryWidget
extends AbstractWidget {
    protected ResearchEntry entry;
    protected AbstractIndexIcon icon;

    public UpcomingEntryWidget(int x, int y, Component text, ResearchEntry entry, boolean showIcon) {
        super(x, y, 123, 12, text);
        this.entry = entry;
        this.icon = showIcon ? IndexIconFactory.fromEntryIcon(entry.getIcon(), false) : null;
        Minecraft mc = Minecraft.m_91087_();
        MutableComponent tooltip = Component.m_237119_();
        tooltip.m_7220_((Component)Component.m_237115_((String)"grimoire.primalmagick.upcoming_tooltip_header"));
        for (SimpleResearchKey parent : this.entry.getParentResearch().getKeys()) {
            ResearchDiscipline disc;
            ResearchEntry parentEntry = ResearchEntries.getEntry(parent);
            if (parentEntry == null && !parent.isKnownByStrict((Player)mc.f_91074_)) {
                tooltip.m_7220_(CommonComponents.f_178388_).m_7220_((Component)Component.m_237115_((String)("research.primalmagick." + parent.getRootKey() + ".text")));
                continue;
            }
            if (parentEntry == null || parentEntry.getKey().isKnownByStrict((Player)mc.f_91074_)) continue;
            MutableComponent comp = Component.m_237115_((String)parentEntry.getNameTranslationKey());
            if (!this.entry.getDisciplineKey().equals(parentEntry.getDisciplineKey()) && (disc = ResearchDisciplines.getDiscipline(parentEntry.getDisciplineKey())) != null) {
                comp.m_7220_((Component)Component.m_237113_((String)" ("));
                comp.m_7220_((Component)Component.m_237115_((String)disc.getNameTranslationKey()));
                comp.m_7220_((Component)Component.m_237113_((String)")"));
            }
            tooltip.m_7220_(CommonComponents.f_178388_).m_7220_((Component)comp);
        }
        this.m_257544_(Tooltip.m_257550_((Component)tooltip));
    }

    public void m_87963_(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int strWidth = mc.f_91062_.m_92895_(this.m_6035_().getString());
        int dx = this.icon == null ? 0 : (this.icon.isLarge() ? 16 : 11);
        Objects.requireNonNull(mc.f_91062_);
        int dy = (this.f_93619_ - 9) / 2;
        if (strWidth <= this.f_93618_ - dx) {
            guiGraphics.m_280614_(mc.f_91062_, this.m_6035_(), this.m_252754_() + dx, this.m_252907_() + dy, Color.GRAY.getRGB(), false);
            if (this.icon != null) {
                this.icon.render(guiGraphics, this.m_252754_() - 2, this.m_252907_() + dy - (this.icon.isLarge() ? 4 : 1));
            }
        } else {
            float scale = (float)(this.f_93618_ - dx) / (float)strWidth;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + dx), (float)(this.m_252907_() + dy) + 1.0f * scale, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            guiGraphics.m_280614_(mc.f_91062_, this.m_6035_(), 0, 0, Color.GRAY.getRGB(), false);
            guiGraphics.m_280168_().m_85849_();
            if (this.icon != null) {
                this.icon.render(guiGraphics, this.m_252754_() - 2, this.m_252907_() + dy - (this.icon.isLarge() ? 4 : 1));
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void m_168797_(NarrationElementOutput output) {
    }
}

