/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public abstract class AbstractProjectMaterialWidget<T extends AbstractProjectMaterial>
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/research_table_overlay.png");
    protected final T material;
    protected final boolean complete;
    protected final boolean consumed;
    protected final boolean hasBonus;

    public AbstractProjectMaterialWidget(T material, int x, int y, Set<Block> surroundings) {
        super(x, y, 16, 16, (Component)Component.m_237119_());
        Minecraft mc = Minecraft.m_91087_();
        this.material = material;
        this.hasBonus = ((AbstractProjectMaterial)material).getBonusReward() > 0.0;
        this.consumed = ((AbstractProjectMaterial)material).isConsumed();
        this.complete = ((AbstractProjectMaterial)material).isSatisfied((Player)mc.f_91074_, this.consumed ? Collections.emptySet() : surroundings);
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.complete) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 8), (float)this.m_252907_(), 200.0f);
            guiGraphics.m_280218_(TEXTURE, 0, 0, 162, 0, 10, 10);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.consumed) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() - 3), (float)(this.m_252907_() - 2), 200.0f);
            guiGraphics.m_280218_(TEXTURE, 0, 0, 172, 0, 10, 10);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.hasBonus) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() - 1), (float)(this.m_252907_() + 10), 200.0f);
            guiGraphics.m_280218_(TEXTURE, 0, 0, 215, 0, 6, 5);
            guiGraphics.m_280168_().m_85849_();
        }
        ArrayList<Component> lines = new ArrayList<Component>(this.getHoverText());
        if (this.consumed) {
            lines.add((Component)Component.m_237115_((String)"tooltip.primalmagick.research_table.material.consumed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        if (this.hasBonus) {
            lines.add((Component)Component.m_237115_((String)"tooltip.primalmagick.research_table.material.has_bonus").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178391_(lines)));
    }

    protected abstract List<Component> getHoverText();

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void m_168797_(NarrationElementOutput output) {
    }
}

