/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.mojang.blaze3d.systems.RenderSystem;
import com.verdantartifice.primalmagick.client.gui.widgets.research_table.AbstractProjectMaterialWidget;
import com.verdantartifice.primalmagick.common.theorycrafting.ExperienceProjectMaterial;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class ExperienceProjectMaterialWidget
extends AbstractProjectMaterialWidget<ExperienceProjectMaterial> {
    private static final ResourceLocation EXPERIENCE_ORB_TEXTURES = new ResourceLocation("textures/entity/experience_orb.png");

    public ExperienceProjectMaterialWidget(ExperienceProjectMaterial material, int x, int y, Set<Block> surroundings) {
        super(material, x, y, surroundings);
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Minecraft mc = Minecraft.m_91087_();
        int textureIndex = this.getTextureIndexByXP(7 * ((ExperienceProjectMaterial)this.material).getLevels());
        int uMin = textureIndex % 4 * 16 * 4;
        int vMin = textureIndex / 4 * 16 * 4;
        double approxTicks = (double)System.currentTimeMillis() / 50.0;
        float r = (float)(Math.sin(approxTicks) + 1.0) * 0.5f;
        float g = 1.0f;
        float b = (float)(Math.sin(approxTicks + 4.188790321350098) + 1.0) * 0.1f;
        float a = 0.5f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        guiGraphics.m_280168_().m_85841_(0.25f, 0.25f, 0.25f);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        guiGraphics.m_280218_(EXPERIENCE_ORB_TEXTURES, 0, 0, uMin, vMin, 63, 63);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_85849_();
        if (((ExperienceProjectMaterial)this.material).getLevels() > 1) {
            MutableComponent amountText = Component.m_237113_((String)Integer.toString(((ExperienceProjectMaterial)this.material).getLevels()));
            int width = mc.f_91062_.m_92852_((FormattedText)amountText);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 16 - width / 2), (float)(this.m_252907_() + 12), 200.0f);
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280430_(mc.f_91062_, (Component)amountText, 0, 0, Color.WHITE.getRGB());
            guiGraphics.m_280168_().m_85849_();
        }
        super.m_87963_(guiGraphics, p_renderButton_1_, p_renderButton_2_, p_renderButton_3_);
    }

    protected int getTextureIndexByXP(int xpValue) {
        if (xpValue >= 2477) {
            return 10;
        }
        if (xpValue >= 1237) {
            return 9;
        }
        if (xpValue >= 617) {
            return 8;
        }
        if (xpValue >= 307) {
            return 7;
        }
        if (xpValue >= 149) {
            return 6;
        }
        if (xpValue >= 73) {
            return 5;
        }
        if (xpValue >= 37) {
            return 4;
        }
        if (xpValue >= 17) {
            return 3;
        }
        if (xpValue >= 7) {
            return 2;
        }
        return xpValue >= 3 ? 1 : 0;
    }

    @Override
    protected List<Component> getHoverText() {
        return Collections.singletonList(Component.m_237115_((String)"argument.entity.options.level.description"));
    }
}

