/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.gui.widgets.research_table;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.OptionalInt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class KnowledgeTotalWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/gui/research_table_overlay.png");
    protected static final DecimalFormat FORMATTER = new DecimalFormat("###.##");
    protected final KnowledgeType type;
    protected final LazyOptional<IPlayerKnowledge> knowledgeOpt;
    protected final OptionalInt successDeltaOpt;

    public KnowledgeTotalWidget(int x, int y, KnowledgeType type) {
        this(x, y, type, OptionalInt.empty());
    }

    public KnowledgeTotalWidget(int x, int y, KnowledgeType type, OptionalInt successDeltaOpt) {
        super(x, y, 16, 19, (Component)Component.m_237119_());
        Minecraft mc = Minecraft.m_91087_();
        this.type = type;
        this.knowledgeOpt = PrimalMagickCapabilities.getKnowledge((Player)mc.f_91074_);
        this.successDeltaOpt = successDeltaOpt;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.m_237115_((String)this.type.getNameTranslationKey()));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.m_252754_(), (float)this.m_252907_(), 0.0f);
        guiGraphics.m_280168_().m_85841_(0.0625f, 0.0625f, 0.0625f);
        guiGraphics.m_280218_(this.type.getIconLocation(), 0, 0, 0, 0, 255, 255);
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.m_252754_(), (float)(this.m_252907_() + 17), 0.0f);
        guiGraphics.m_280218_(TEXTURE, 0, 0, 182, 2, 16, 2);
        guiGraphics.m_280168_().m_85849_();
        this.knowledgeOpt.ifPresent(knowledge -> {
            int levels = knowledge.getKnowledge(this.type);
            MutableComponent amountText = Component.m_237113_((String)Integer.toString(levels));
            int width = mc.f_91062_.m_92852_((FormattedText)amountText);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 16 - width / 2), (float)(this.m_252907_() + 12), 5.0f);
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
            guiGraphics.m_280430_(mc.f_91062_, (Component)amountText, 0, 0, Color.WHITE.getRGB());
            guiGraphics.m_280168_().m_85849_();
            int rawPoints = knowledge.getKnowledgeRaw(this.type);
            int levelPoints = rawPoints % this.type.getProgression();
            int px = (int)(16.0 * ((double)levelPoints / (double)this.type.getProgression()));
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)this.m_252754_(), (float)(this.m_252907_() + 17), 1.0f);
            guiGraphics.m_280218_(TEXTURE, 0, 0, 182, 0, px, 2);
            guiGraphics.m_280168_().m_85849_();
        });
        this.successDeltaOpt.ifPresent(points -> {
            double levels = (double)points / (double)this.type.getProgression();
            String levelStr = FORMATTER.format(Math.abs(levels));
            if (points > 0) {
                MutableComponent previewText = Component.m_237110_((String)"label.primalmagick.research_table.theory_gain_preview.positive", (Object[])new Object[]{levelStr}).m_130940_(ChatFormatting.GREEN);
                int width = mc.f_91062_.m_92852_((FormattedText)previewText);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)(this.m_252754_() + 16 - width / 2), (float)this.m_252907_(), 5.0f);
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                guiGraphics.m_280430_(mc.f_91062_, (Component)previewText, 0, 0, Color.WHITE.getRGB());
                guiGraphics.m_280168_().m_85849_();
                if (levels == 1.0) {
                    lines.add(Component.m_237110_((String)"tooltip.primalmagick.research_table.theory_gain_preview.positive.single", (Object[])new Object[]{levelStr}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                } else {
                    lines.add(Component.m_237110_((String)"tooltip.primalmagick.research_table.theory_gain_preview.positive.multiple", (Object[])new Object[]{levelStr}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }
        });
        this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178391_(lines)));
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        return false;
    }

    public void m_168797_(NarrationElementOutput output) {
    }
}

