/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.recipe_book;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.client.gui.recipe_book.ArcaneRecipeCollection;
import com.verdantartifice.primalmagick.client.recipe_book.ArcaneRecipeBookCategories;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.items.concoctions.AlchemicalBombItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientArcaneRecipeBook {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected Map<ArcaneRecipeBookCategories, List<ArcaneRecipeCollection>> collectionsByTab = ImmutableMap.of();
    protected List<ArcaneRecipeCollection> allCollections = ImmutableList.of();
    protected final ArcaneRecipeBook book;

    public ClientArcaneRecipeBook(ArcaneRecipeBook book) {
        this.book = book;
    }

    public void setupCollections(Iterable<Recipe<?>> recipes, RegistryAccess registryAccess) {
        Map<ArcaneRecipeBookCategories, List<List<Recipe<?>>>> recipeListMap = ClientArcaneRecipeBook.categorizeAndGroupRecipes(recipes, registryAccess);
        HashMap recipeCollectionMap = new HashMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        recipeListMap.forEach((category, recipeLists) -> recipeCollectionMap.put(category, (List)recipeLists.stream().map(recipeList -> new ArcaneRecipeCollection(registryAccess, (List<Recipe<?>>)recipeList)).peek(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0)).collect(ImmutableList.toImmutableList())));
        ArcaneRecipeBookCategories.AGGREGATE_CATEGORIES.forEach((searchCategory, subCategories) -> recipeCollectionMap.put(searchCategory, (List)subCategories.stream().flatMap(cat -> ((List)recipeCollectionMap.getOrDefault(cat, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.collectionsByTab = ImmutableMap.copyOf(recipeCollectionMap);
        this.allCollections = builder.build();
    }

    protected static Map<ArcaneRecipeBookCategories, List<List<Recipe<?>>>> categorizeAndGroupRecipes(Iterable<Recipe<?>> recipes, RegistryAccess registryAccess) {
        HashMap retVal = new HashMap();
        HashBasedTable table = HashBasedTable.create();
        for (Recipe<?> recipe : recipes) {
            if (!ArcaneRecipeBook.isValid(recipe) && recipe.m_5598_() || recipe.m_142505_()) continue;
            ArcaneRecipeBookCategories category = ClientArcaneRecipeBook.getCategory(recipe, registryAccess);
            String group = recipe.m_6076_();
            if (group.isEmpty()) {
                retVal.computeIfAbsent(category, c -> new ArrayList()).add(ImmutableList.of(recipe));
                continue;
            }
            ArrayList list = (ArrayList)table.get((Object)category, (Object)group);
            if (list == null) {
                list = new ArrayList();
                table.put((Object)category, (Object)group, list);
                retVal.computeIfAbsent(category, c -> new ArrayList()).add(list);
            }
            list.add(recipe);
        }
        return retVal;
    }

    protected static ArcaneRecipeBookCategories getCategory(Recipe<?> recipe, RegistryAccess registryAccess) {
        RecipeType type = recipe.m_6671_();
        if (type == RecipeTypesPM.ARCANE_CRAFTING.get()) {
            return ArcaneRecipeBookCategories.CRAFTING_ARCANE;
        }
        if (type == RecipeTypesPM.CONCOCTING.get()) {
            return recipe.m_8043_(registryAccess).m_41720_() instanceof AlchemicalBombItem ? ArcaneRecipeBookCategories.CONCOCTER_BOMB : ArcaneRecipeBookCategories.CONCOCTER_DRINKABLE;
        }
        if (type == RecipeTypesPM.DISSOLUTION.get()) {
            return recipe.m_8043_(registryAccess).m_204117_(Tags.Items.DUSTS) ? ArcaneRecipeBookCategories.DISSOLUTION_ORES : ArcaneRecipeBookCategories.DISSOLUTION_MISC;
        }
        if (type == RecipeType.f_44107_ && recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            return switch (craftingRecipe.m_245232_()) {
                default -> throw new IncompatibleClassChangeError();
                case CraftingBookCategory.BUILDING -> ArcaneRecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
                case CraftingBookCategory.EQUIPMENT -> ArcaneRecipeBookCategories.CRAFTING_EQUIPMENT;
                case CraftingBookCategory.REDSTONE -> ArcaneRecipeBookCategories.CRAFTING_REDSTONE;
                case CraftingBookCategory.MISC -> ArcaneRecipeBookCategories.CRAFTING_MISC;
            };
        }
        if (type == RecipeType.f_44108_ && recipe instanceof SmeltingRecipe) {
            SmeltingRecipe smeltingRecipe = (SmeltingRecipe)recipe;
            return switch (smeltingRecipe.m_245534_()) {
                default -> throw new IncompatibleClassChangeError();
                case CookingBookCategory.BLOCKS -> ArcaneRecipeBookCategories.FURNACE_BLOCKS;
                case CookingBookCategory.FOOD -> ArcaneRecipeBookCategories.FURNACE_FOOD;
                case CookingBookCategory.MISC -> ArcaneRecipeBookCategories.FURNACE_MISC;
            };
        }
        return ArcaneRecipeBookCategories.UNKNOWN;
    }

    public ArcaneRecipeBook getData() {
        return this.book;
    }

    public List<ArcaneRecipeCollection> getCollections() {
        return this.allCollections;
    }

    public List<ArcaneRecipeCollection> getCollection(ArcaneRecipeBookCategories category) {
        return this.collectionsByTab.getOrDefault((Object)category, Collections.emptyList());
    }
}

