/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.common.entities.misc.SinCrystalEntity;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;

public class SinCrystalRenderer
extends EntityRenderer<SinCrystalEntity> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/end_crystal/end_crystal.png");
    protected static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)TEXTURE);
    protected static final float ANGLE = (float)Math.sin(0.7853981633974483);
    protected final ModelPart glass;
    protected final ModelPart cube;

    public SinCrystalRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        ModelPart model = context.m_174023_(ModelLayers.f_171145_);
        this.glass = model.m_171324_("glass");
        this.cube = model.m_171324_("cube");
    }

    public ResourceLocation getTextureLocation(SinCrystalEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(SinCrystalEntity livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_((Entity)livingEntityIn, camera, camX, camY, camZ) || livingEntityIn.getBeamTarget() != null;
    }

    public static float getDeltaY(SinCrystalEntity entity, float partialTicks) {
        float f = (float)entity.innerRotation + partialTicks;
        float f1 = Mth.m_14031_((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    public void render(SinCrystalEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        float deltaY = SinCrystalRenderer.getDeltaY(entityIn, partialTicks);
        float f1 = ((float)entityIn.innerRotation + partialTicks) * 3.0f;
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RENDER_TYPE);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(2.0f, 2.0f, 2.0f);
        matrixStackIn.m_85837_(0.0, -0.5, 0.0);
        int i = OverlayTexture.f_118083_;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
        matrixStackIn.m_85837_(0.0, (double)(1.5f + deltaY / 2.0f), 0.0);
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, ANGLE, 0.0f, ANGLE));
        this.glass.m_104301_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.m_85841_(0.875f, 0.875f, 0.875f);
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, ANGLE, 0.0f, ANGLE));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
        this.glass.m_104301_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.m_85841_(0.875f, 0.875f, 0.875f);
        matrixStackIn.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, ANGLE, 0.0f, ANGLE));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(f1));
        this.cube.m_104301_(matrixStackIn, ivertexbuilder, packedLightIn, i);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
        BlockPos blockpos = entityIn.getBeamTarget();
        if (blockpos != null) {
            float targetX = (float)blockpos.m_123341_() + 0.5f;
            float targetY = (float)blockpos.m_123342_() + 0.5f;
            float targetZ = (float)blockpos.m_123343_() + 0.5f;
            float dx = (float)((double)targetX - entityIn.m_20185_());
            float dy = (float)((double)targetY - entityIn.m_20186_());
            float dz = (float)((double)targetZ - entityIn.m_20189_());
            matrixStackIn.m_85837_((double)dx, (double)dy, (double)dz);
            EnderDragonRenderer.m_114187_((float)(-dx), (float)(-dy + deltaY), (float)(-dz), (float)partialTicks, (int)entityIn.innerRotation, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn);
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

