/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.renderers.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.renderers.entity.model.SpellProjectileModel;
import com.verdantartifice.primalmagick.client.renderers.models.ModelLayersPM;
import com.verdantartifice.primalmagick.common.entities.projectiles.SpellProjectileEntity;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SpellProjectileRenderer
extends EntityRenderer<SpellProjectileEntity> {
    protected static final ResourceLocation TEXTURE = PrimalMagick.resource("textures/entity/spell_projectile.png");
    protected static final RenderType TRANSLUCENT_TYPE = RenderType.m_110473_((ResourceLocation)TEXTURE);
    protected final SpellProjectileModel model;

    public SpellProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpellProjectileModel(context.m_174023_(ModelLayersPM.SPELL_PROJECTILE));
    }

    protected int getBlockLightLevel(SpellProjectileEntity entityIn, BlockPos blockPos) {
        return 15;
    }

    public void render(SpellProjectileEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        float yaw = Mth.m_14189_((float)entity.f_19859_, (float)entity.m_146908_(), (float)partialTicks);
        float pitch = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        float ticks = (float)entity.f_19797_ + partialTicks;
        Color c = new Color(entity.getColor());
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.15, 0.0);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(ticks * 0.1f)) * 180.0f));
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14089_((float)(ticks * 0.1f)) * 180.0f));
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(ticks * 0.15f)) * 360.0f));
        matrixStack.m_85841_(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim(entity, 0.0f, 0.0f, 0.0f, yaw, pitch);
        VertexConsumer coreVertexBuilder = buffer.m_6299_(this.model.m_103119_(TEXTURE));
        this.model.m_7695_(matrixStack, coreVertexBuilder, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        matrixStack.m_85841_(1.5f, 1.5f, 1.5f);
        VertexConsumer glowVertexBuilder = buffer.m_6299_(TRANSLUCENT_TYPE);
        this.model.m_7695_(matrixStack, glowVertexBuilder, packedLight, OverlayTexture.f_118083_, r, g, b, 0.5f);
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(SpellProjectileEntity entity) {
        return TEXTURE;
    }
}

