/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.tips;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record TipDefinition(String translationKey, Optional<CompoundResearchKey> requiredResearch) {
    public static final Codec<TipDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translationKey").forGetter(TipDefinition::translationKey), (App)CompoundResearchKey.CODEC.optionalFieldOf("requiredResearch").forGetter(TipDefinition::requiredResearch)).apply((Applicative)instance, TipDefinition::new));

    public Component getText() {
        return Component.m_237115_((String)this.translationKey);
    }

    public boolean shouldShow(Player player) {
        if (this.requiredResearch().isPresent()) {
            return this.requiredResearch().get().isKnownByStrict(player);
        }
        return true;
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static Builder builder(String id) {
        return new Builder(PrimalMagick.resource(id));
    }

    public static class Builder {
        protected final ResourceLocation id;
        protected String translationKey;
        protected Optional<CompoundResearchKey> requiredResearch;

        protected Builder(ResourceLocation id) {
            this.id = id;
            this.translationKey = String.join((CharSequence)".", "tip", id.m_135827_(), id.m_135815_());
            this.requiredResearch = Optional.empty();
        }

        public Builder translationKey(String key) {
            this.translationKey = key;
            return this;
        }

        public Builder requiredResearch(CompoundResearchKey researchKey) {
            this.requiredResearch = Optional.ofNullable(researchKey);
            return this;
        }

        public TipDefinition build() {
            return new TipDefinition(this.translationKey, this.requiredResearch);
        }

        public void save(BiConsumer<ResourceLocation, TipDefinition> consumer) {
            consumer.accept(this.id, this.build());
        }
    }
}

