/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.tips;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.verdantartifice.primalmagick.client.tips.TipDefinition;
import com.verdantartifice.primalmagick.client.tips.TipManager;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TipLoader
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static TipLoader INSTANCE;

    protected TipLoader() {
        super(GSON, "tips");
    }

    public static TipLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve TipLoader until resources are loaded at least once");
        }
        return INSTANCE;
    }

    public static TipLoader getOrCreateInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TipLoader();
        }
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        TipManager.clearTips();
        pObject.entrySet().forEach(entry -> {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!location.m_135815_().startsWith("_")) {
                TipDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tipDef -> TipManager.setTipDefinition(location, tipDef));
            }
        });
        LOGGER.info("Loaded {} tips", (Object)TipManager.getAllTipDefinitions().size());
    }
}

