/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.tips;

import com.verdantartifice.primalmagick.client.tips.TipDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TipManager {
    protected static final Map<ResourceLocation, TipDefinition> REGISTRY = new HashMap<ResourceLocation, TipDefinition>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void clearTips() {
        REGISTRY.clear();
    }

    public static void setTipDefinition(ResourceLocation id, TipDefinition tip) {
        if (REGISTRY.containsKey(id)) {
            LOGGER.warn("Tip definition {} is already registered", (Object)id.toString());
        } else {
            REGISTRY.put(id, tip);
        }
    }

    public static Optional<TipDefinition> getTipDefinition(ResourceLocation id) {
        return Optional.ofNullable(REGISTRY.get(id));
    }

    public static Collection<TipDefinition> getAllTipDefinitions() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }

    public static TipDefinition getRandomTipForPlayer(Player player, RandomSource random) {
        List<TipDefinition> filteredTips = TipManager.getAllTipDefinitions().stream().filter(tip -> tip.shouldShow(player)).toList();
        return filteredTips.get(random.m_188503_(filteredTips.size()));
    }
}

