/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class GuiUtils {
    public static boolean renderItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String text, boolean hideStackOverlay) {
        boolean retVal = false;
        if (stack != null && !stack.m_41619_()) {
            Minecraft mc = Minecraft.m_91087_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 32.0f);
            guiGraphics.m_280480_(stack, x, y);
            if (!hideStackOverlay) {
                guiGraphics.m_280302_(mc.f_91062_, stack, x, y, text);
            }
            guiGraphics.m_280168_().m_85849_();
            retVal = true;
        }
        return retVal;
    }

    public static boolean renderItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y, String text, boolean hideStackOverlay, Optional<Vec3> scaleOpt) {
        boolean retVal = false;
        if (stack != null && !stack.m_41619_()) {
            Minecraft mc = Minecraft.m_91087_();
            ItemRenderer itemRenderer = mc.m_91291_();
            BakedModel bakedModel = itemRenderer.m_174264_(stack, (Level)mc.f_91073_, (LivingEntity)mc.f_91074_, 0);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 32.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(x + 8), (float)(y + 8), 150.0f);
            try {
                boolean flag;
                guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
                scaleOpt.ifPresent(scale -> guiGraphics.m_280168_().m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_));
                boolean bl = flag = !bakedModel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                itemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
                guiGraphics.m_280262_();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
                crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
                throw new ReportedException(crashreport);
            }
            guiGraphics.m_280168_().m_85849_();
            if (!hideStackOverlay) {
                guiGraphics.m_280302_(mc.f_91062_, stack, x, y, text);
            }
            guiGraphics.m_280168_().m_85849_();
            retVal = true;
        }
        return retVal;
    }

    public static void renderItemTooltip(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        List lines = stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)(mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
        guiGraphics.renderComponentTooltip(mc.f_91062_, lines, x, y, stack);
    }

    public static void renderCustomTooltip(GuiGraphics guiGraphics, List<Component> textList, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.renderComponentTooltip(mc.f_91062_, textList, x, y, ItemStack.f_41583_);
    }

    public static void renderSourcesForPlayer(GuiGraphics guiGraphics, @Nullable SourceList sources, @Nullable Player player, int startX, int startY) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        int x = 0;
        int index = 0;
        for (Source source : sources.getSourcesSorted()) {
            if (source == null) continue;
            x = startX + index * 18;
            if (source.isDiscovered(player)) {
                GuiUtils.renderSourceIcon(guiGraphics, x, startY, source, sources.getAmount(source), 998.0);
            } else {
                GuiUtils.renderUnknownSourceIcon(guiGraphics, x, startY, sources.getAmount(source), 998.0);
            }
            ++index;
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderSourceIcon(GuiGraphics guiGraphics, int x, int y, @Nullable Source source, int amount, double z) {
        if (source != null) {
            GuiUtils.renderSourceIcon(guiGraphics, x, y, source.getAtlasLocation(), amount, z);
        }
    }

    public static void renderUnknownSourceIcon(GuiGraphics guiGraphics, int x, int y, int amount, double z) {
        GuiUtils.renderSourceIcon(guiGraphics, x, y, Source.getUnknownAtlasLocation(), amount, z);
    }

    protected static void renderSourceIcon(GuiGraphics guiGraphics, int x, int y, @Nonnull ResourceLocation imageLoc, int amount, double z) {
        boolean isBlendOn = GL11.glIsEnabled((int)3042);
        Minecraft mc = Minecraft.m_91087_();
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.m_280168_().m_85836_();
        TextureAtlasSprite sprite = mc.m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(imageLoc);
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
        builder.m_5483_((double)x + 0.0, (double)y + 16.0, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_5483_((double)x + 16.0, (double)y + 16.0, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_5483_((double)x + 16.0, (double)y + 0.0, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_5483_((double)x + 0.0, (double)y + 0.0, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        if (amount > 0) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(0.0, 0.0, z + 1.0);
            guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            String amountStr = Integer.toString(amount);
            int amountWidth = mc.f_91062_.m_92895_(amountStr);
            Font font = mc.f_91062_;
            Objects.requireNonNull(mc.f_91062_);
            guiGraphics.m_280488_(font, amountStr, 32 - amountWidth + x * 2, 32 - 9 + y * 2, Color.WHITE.getRGB());
            guiGraphics.m_280168_().m_85849_();
        }
        if (!isBlendOn) {
            RenderSystem.disableBlend();
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static void renderSourcesBillboard(PoseStack poseStack, MultiBufferSource buffers, double x, double y, double z, SourceList sources, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        double interpolatedPlayerX = mc.f_91074_.f_19854_ + (double)partialTicks * (mc.f_91074_.m_20185_() - mc.f_91074_.f_19854_);
        double interpolatedPlayerY = mc.f_91074_.f_19855_ + (double)partialTicks * (mc.f_91074_.m_20186_() - mc.f_91074_.f_19855_);
        double interpolatedPlayerZ = mc.f_91074_.f_19856_ + (double)partialTicks * (mc.f_91074_.m_20189_() - mc.f_91074_.f_19856_);
        double dx = interpolatedPlayerX - x + 0.5;
        double dz = interpolatedPlayerZ - z + 0.5;
        float rotYaw = 180.0f + (float)(Mth.m_14136_((double)dx, (double)dz) * 180.0 / Math.PI);
        float scale = 0.03f;
        double shiftX = 0.0;
        double startDeltaX = 16.0 * (double)sources.getSources().size() / 2.0 * (double)scale;
        for (Source source : sources.getSourcesSorted()) {
            int amount = sources.getAmount(source);
            if (amount <= 0) continue;
            poseStack.m_85836_();
            poseStack.m_85837_(x - interpolatedPlayerX, y - interpolatedPlayerY - 0.5, z - interpolatedPlayerZ);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotYaw));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_85837_(shiftX - startDeltaX, 0.0, 0.0);
            poseStack.m_85841_(scale, scale, scale);
            ResourceLocation texLoc = source.isDiscovered((Player)mc.f_91074_) ? source.getAtlasLocation() : Source.getUnknownAtlasLocation();
            TextureAtlasSprite sprite = mc.m_91304_().m_119428_(TextureAtlas.f_118259_).m_118316_(texLoc);
            VertexConsumer builder = buffers.m_6299_(RenderType.m_110463_());
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            builder.m_252986_(matrix, 0.0f, 16.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix, 16.0f, 16.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix, 16.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_7120_(240, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            String amountStr = Integer.toString(amount);
            int amountWidth = mc.f_91062_.m_92895_(amountStr);
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, -0.5f);
            double d = 32.0 - (double)amountWidth;
            Objects.requireNonNull(mc.f_91062_);
            poseStack.m_85837_(d, 32.0 - 9.0, 0.0);
            mc.f_91062_.m_272078_(amountStr, 0.0f, 0.0f, Color.WHITE.getRGB(), true, poseStack.m_85850_().m_252922_(), buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0, mc.f_91062_.m_92718_());
            poseStack.m_85849_();
            poseStack.m_85849_();
            shiftX += 16.0 * (double)scale;
        }
    }
}

