/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.affinities;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.affinities.AffinityType;
import com.verdantartifice.primalmagick.common.affinities.EnchantmentBonusAffinity;
import com.verdantartifice.primalmagick.common.affinities.EntityTypeAffinity;
import com.verdantartifice.primalmagick.common.affinities.IAffinity;
import com.verdantartifice.primalmagick.common.affinities.IAffinitySerializer;
import com.verdantartifice.primalmagick.common.affinities.ItemAffinity;
import com.verdantartifice.primalmagick.common.affinities.PotionBonusAffinity;
import com.verdantartifice.primalmagick.common.crafting.IHasManaCost;
import com.verdantartifice.primalmagick.common.menus.FakeMenu;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="primalmagick")
public class AffinityManager
extends SimpleJsonResourceReloadListener {
    protected static final int MAX_AFFINITY = 100;
    protected static final int HISTORY_LIMIT = 100;
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected static final Map<AffinityType, IAffinitySerializer<?>> SERIALIZERS = new ImmutableMap.Builder().put((Object)AffinityType.ITEM, (Object)ItemAffinity.SERIALIZER).put((Object)AffinityType.POTION_BONUS, (Object)PotionBonusAffinity.SERIALIZER).put((Object)AffinityType.ENCHANTMENT_BONUS, (Object)EnchantmentBonusAffinity.SERIALIZER).put((Object)AffinityType.ENTITY_TYPE, (Object)EntityTypeAffinity.SERIALIZER).build();
    private static final Logger LOGGER = LogManager.getLogger();
    private static AffinityManager INSTANCE;
    public static final int MAX_SCAN_COUNT = 108;
    private Map<AffinityType, Map<ResourceLocation, IAffinity>> affinities = new HashMap<AffinityType, Map<ResourceLocation, IAffinity>>();
    private final Map<AffinityType, Map<ResourceLocation, CompletableFuture<SourceList>>> resultCache = new ConcurrentHashMap<AffinityType, Map<ResourceLocation, CompletableFuture<SourceList>>>();
    private final Object resultCacheLock = new Object();

    protected AffinityManager() {
        super(GSON, "affinities");
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)AffinityManager.getOrCreateInstance());
    }

    public static AffinityManager getOrCreateInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AffinityManager();
        }
        return INSTANCE;
    }

    public static AffinityManager getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve AffinityController until resources are loaded at least once");
        }
        return INSTANCE;
    }

    public static IAffinitySerializer<?> getSerializer(AffinityType type) {
        return SERIALIZERS.get((Object)type);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.affinities.clear();
        this.clearCachedResults();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.m_135815_().startsWith("_")) continue;
            try {
                IAffinity aff = this.deserializeAffinity(location, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top member"));
                if (aff == null) {
                    LOGGER.info("Skipping loading affinity {} as its serializer returned null", (Object)location);
                    continue;
                }
                this.registerAffinity(aff);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Parsing error loading affinity {}", (Object)location, (Object)e);
            }
        }
        for (Map.Entry<Object, Object> entry : this.affinities.entrySet()) {
            LOGGER.info("Loaded {} {} affinity definitions", (Object)((Map)entry.getValue()).size(), (Object)((AffinityType)((Object)entry.getKey())).m_7912_());
        }
    }

    public void replaceAffinities(List<IAffinity> affinities) {
        this.affinities.clear();
        this.clearCachedResults();
        for (IAffinity iAffinity : affinities) {
            this.registerAffinity(iAffinity);
        }
        for (Map.Entry entry : this.affinities.entrySet()) {
            LOGGER.info("Updated {} {} affinity definitions", (Object)((Map)entry.getValue()).size(), (Object)((AffinityType)((Object)entry.getKey())).m_7912_());
        }
    }

    protected IAffinity deserializeAffinity(ResourceLocation id, JsonObject json) {
        String s = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        AffinityType type = AffinityType.parse(s);
        IAffinitySerializer<?> serializer = SERIALIZERS.get((Object)type);
        if (serializer == null) {
            throw new JsonSyntaxException("Invalid or unsupported affinity type '" + s + "'");
        }
        return serializer.read(id, json);
    }

    @Nullable
    protected IAffinity getAffinity(AffinityType type, ResourceLocation id) {
        return (IAffinity)this.affinities.getOrDefault((Object)type, Collections.emptyMap()).get(id);
    }

    public CompletableFuture<IAffinity> getOrGenerateItemAffinityAsync(@Nonnull ResourceLocation id, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess, @Nonnull List<ResourceLocation> history) {
        Map map = this.affinities.computeIfAbsent(AffinityType.ITEM, affinityType -> new HashMap());
        if (map.containsKey(id)) {
            return CompletableFuture.completedFuture((IAffinity)map.get(id));
        }
        return this.generateItemAffinityAsync(id, recipeManager, registryAccess, history);
    }

    @Nonnull
    public Collection<IAffinity> getAllAffinities() {
        return this.affinities.values().stream().flatMap(typeMap -> typeMap.values().stream()).collect(Collectors.toSet());
    }

    protected void registerAffinity(@Nullable IAffinity affinity) {
        this.affinities.computeIfAbsent(affinity.getType(), affinityType -> new HashMap()).put(affinity.getTarget(), affinity);
    }

    protected boolean isRegistered(AffinityType type, ResourceLocation id) {
        if (type == null || id == null) {
            return false;
        }
        return this.affinities.getOrDefault((Object)type, Collections.emptyMap()).containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCachedResults() {
        Object object = this.resultCacheLock;
        synchronized (object) {
            this.resultCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CompletableFuture<SourceList> getCachedItemResult(ItemStack stack) {
        Object object = this.resultCacheLock;
        synchronized (object) {
            return (CompletableFuture)this.resultCache.getOrDefault((Object)AffinityType.ITEM, Collections.emptyMap()).get(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCachedItemResult(ItemStack stack, @Nullable CompletableFuture<SourceList> result) {
        if (result != null) {
            Object object = this.resultCacheLock;
            synchronized (object) {
                this.resultCache.computeIfAbsent(AffinityType.ITEM, $ -> new ConcurrentHashMap()).put(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CompletableFuture<SourceList> getCachedEntityResult(EntityType<?> entityType) {
        Object object = this.resultCacheLock;
        synchronized (object) {
            return (CompletableFuture)this.resultCache.getOrDefault((Object)AffinityType.ENTITY_TYPE, Collections.emptyMap()).get(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCachedEntityResult(EntityType<?> entityType, @Nullable CompletableFuture<SourceList> result) {
        if (result != null) {
            Object object = this.resultCacheLock;
            synchronized (object) {
                this.resultCache.computeIfAbsent(AffinityType.ENTITY_TYPE, $ -> new ConcurrentHashMap()).put(ForgeRegistries.ENTITY_TYPES.getKey(entityType), result);
            }
        }
    }

    public Optional<SourceList> getAffinityValues(@Nullable EntityType<?> type, @Nonnull RegistryAccess registryAccess) {
        Optional<SourceList> retVal;
        try {
            CompletableFuture<SourceList> cachedResult = this.getCachedEntityResult(type);
            if (cachedResult == null) {
                this.setCachedEntityResult(type, this.getAffinityValuesAsync(type, registryAccess));
                retVal = Optional.empty();
            } else {
                retVal = cachedResult.isDone() ? Optional.ofNullable(cachedResult.get()) : Optional.empty();
            }
        }
        catch (CancellationException e) {
            LOGGER.warn("Affinity calculation for entity type {} was cancelled before completion", (Object)ForgeRegistries.ENTITY_TYPES.getKey(type));
            retVal = Optional.empty();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Affinity calculation for entity type {} was interrupted before completion", (Object)ForgeRegistries.ENTITY_TYPES.getKey(type));
            retVal = Optional.empty();
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to calculate entity type affinities", (Throwable)e);
            retVal = Optional.empty();
        }
        return retVal;
    }

    public CompletableFuture<SourceList> getAffinityValuesAsync(EntityType<?> type, RegistryAccess registryAccess) {
        return CompletableFuture.supplyAsync(() -> {
            IAffinity entityAffinity = this.getAffinity(AffinityType.ENTITY_TYPE, ForgeRegistries.ENTITY_TYPES.getKey((Object)type));
            if (entityAffinity == null) {
                return SourceList.EMPTY;
            }
            return (SourceList)((CompletableFuture)entityAffinity.getTotalAsync(null, registryAccess, new ArrayList<ResourceLocation>()).thenApply(sources -> this.capAffinities((SourceList)sources, 100))).join();
        }, Util.m_183991_()).exceptionally(e -> {
            LOGGER.error("Failed to generate affinity values for entity " + type.toString(), e);
            return SourceList.EMPTY;
        });
    }

    public Optional<SourceList> getAffinityValues(@Nullable ItemStack stack, @Nonnull Level level) {
        Optional<SourceList> retVal;
        try {
            CompletableFuture<SourceList> cachedResult = this.getCachedItemResult(stack);
            if (cachedResult == null) {
                this.setCachedItemResult(stack, this.getAffinityValuesAsync(stack, level));
                retVal = Optional.empty();
            } else {
                retVal = cachedResult.isDone() ? Optional.ofNullable(cachedResult.get()) : Optional.empty();
            }
        }
        catch (CancellationException e) {
            LOGGER.warn("Affinity calculation for stack of item {} was cancelled before completion", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
            retVal = Optional.empty();
        }
        catch (InterruptedException e) {
            LOGGER.warn("Affinity calculation for stack of item {} was interrupted before completion", (Object)ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
            retVal = Optional.empty();
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to calculate item affinities", (Throwable)e);
            retVal = Optional.empty();
        }
        return retVal;
    }

    public CompletableFuture<SourceList> getAffinityValuesAsync(@Nonnull ItemStack stack, @Nonnull Level level) {
        return CompletableFuture.supplyAsync(() -> this.getAffinityValuesAsync(stack, level.m_7465_(), level.m_9598_(), new ArrayList<ResourceLocation>()).join(), Util.m_183991_()).exceptionally(e -> {
            LOGGER.error("Failed to generate affinity values for item stack " + stack.toString(), e);
            return SourceList.EMPTY;
        });
    }

    protected CompletableFuture<SourceList> getAffinityValuesAsync(@Nonnull ItemStack stack, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess, @Nonnull List<ResourceLocation> history) {
        if (stack.m_41619_()) {
            return CompletableFuture.completedFuture(SourceList.EMPTY);
        }
        ResourceLocation stackItemLoc = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        CompletableFuture<IAffinity> itemAffinityFuture = this.isRegistered(AffinityType.ITEM, stackItemLoc) ? CompletableFuture.completedFuture(this.getAffinity(AffinityType.ITEM, stackItemLoc)) : this.generateItemAffinityAsync(stackItemLoc, recipeManager, registryAccess, history);
        return ((CompletableFuture)((CompletableFuture)itemAffinityFuture.thenCompose(itemAffinity -> itemAffinity == null ? CompletableFuture.completedFuture(SourceList.EMPTY) : itemAffinity.getTotalAsync(recipeManager, registryAccess, history))).thenCompose(sources -> this.addBonusAffinitiesAsync(stack, (SourceList)sources, recipeManager, registryAccess))).thenApply(sources -> this.capAffinities((SourceList)sources, 100));
    }

    protected CompletableFuture<IAffinity> generateItemAffinityAsync(@Nonnull ResourceLocation id, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess, @Nonnull List<ResourceLocation> history) {
        if (this.isRegistered(AffinityType.ITEM, id)) {
            return CompletableFuture.completedFuture(this.getAffinity(AffinityType.ITEM, id));
        }
        if (history.contains(id)) {
            return CompletableFuture.completedFuture(null);
        }
        history.add(id);
        if (history.size() < 100) {
            CompletableFuture<RecipeValues> valuesFuture = this.generateItemAffinityValuesFromRecipesAsync(id, recipeManager, registryAccess, history);
            return valuesFuture.thenApply(values -> {
                ItemAffinity retVal = new ItemAffinity(id, values.values());
                retVal.setSourceRecipe(values.recipe());
                this.registerAffinity(retVal);
                return retVal;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nullable
    protected CompletableFuture<RecipeValues> generateItemAffinityValuesFromRecipesAsync(@Nonnull ResourceLocation id, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess, @Nonnull List<ResourceLocation> history) {
        List<CompletableFuture> recipeValueFutures = recipeManager.m_44051_().stream().filter(r -> r.m_8043_(registryAccess) != null && ForgeRegistries.ITEMS.getKey((Object)r.m_8043_(registryAccess).m_41720_()).equals((Object)id)).map(recipe -> this.generateItemAffinityValuesFromIngredientsAsync((Recipe<?>)recipe, recipeManager, registryAccess, history).thenApply(ingSources -> {
            SourceList retVal = ingSources.copy();
            if (recipe instanceof IHasManaCost) {
                IHasManaCost manaRecipe = (IHasManaCost)recipe;
                SourceList manaCosts = manaRecipe.getManaCosts();
                for (Source source : manaCosts.getSources()) {
                    int manaAmount;
                    if (manaCosts.getAmount(source) <= 0 || (manaAmount = (int)(Math.sqrt(1 + manaCosts.getAmount(source) / 2) / (double)recipe.m_8043_(registryAccess).m_41613_())) <= 0) continue;
                    retVal = retVal.add(source, manaAmount);
                }
            }
            return new RecipeValues(Optional.ofNullable(recipe.m_6423_()), retVal);
        })).toList();
        return Util.m_137567_(recipeValueFutures).thenApply(recipeValuesList -> {
            MutableObject retVal = new MutableObject((Object)RecipeValues.EMPTY);
            MutableInt maxValue = new MutableInt(Integer.MAX_VALUE);
            recipeValuesList.forEach(recipeValue -> {
                int manaSize = recipeValue.values().getManaSize();
                if (manaSize > 0 && manaSize < maxValue.intValue()) {
                    retVal.setValue(recipeValue);
                    maxValue.setValue(manaSize);
                }
            });
            return (RecipeValues)retVal.getValue();
        });
    }

    @Nonnull
    protected CompletableFuture<SourceList> generateItemAffinityValuesFromIngredientsAsync(@Nonnull Recipe<?> recipe, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess, @Nonnull List<ResourceLocation> history) {
        CompletionStage<Object> containerFuture;
        NonNullList ingredients = recipe.m_7527_();
        ItemStack output = recipe.m_8043_(registryAccess);
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            TransientCraftingContainer inv = new TransientCraftingContainer((AbstractContainerMenu)new FakeMenu(), ingredients.size(), 1);
            ArrayList<CompletableFuture<ItemStack>> ingFutures = new ArrayList<CompletableFuture<ItemStack>>();
            for (Ingredient ingredient2 : ingredients) {
                ingFutures.add(this.getMatchingItemStackAsync(ingredient2, recipeManager, registryAccess, history));
            }
            containerFuture = Util.m_137567_(ingFutures).thenApply(arg_0 -> AffinityManager.lambda$generateItemAffinityValuesFromIngredientsAsync$20((CraftingContainer)inv, craftingRecipe, arg_0));
        } else {
            containerFuture = CompletableFuture.completedFuture(NonNullList.m_122779_());
        }
        MutableObject intermediate = new MutableObject((Object)SourceList.EMPTY);
        List<CompletableFuture> ingFutures = ingredients.stream().map(ingredient -> this.getMatchingItemStackAsync((Ingredient)ingredient, recipeManager, registryAccess, history).thenCompose(ingStack -> this.getAffinityValuesAsync((ItemStack)ingStack, recipeManager, registryAccess, history))).toList();
        CompletionStage intermediateFuture = Util.m_137567_(ingFutures).thenApply(valueList -> {
            valueList.forEach(values -> intermediate.setValue((Object)((SourceList)intermediate.getValue()).add((SourceList)values)));
            return (SourceList)intermediate.getValue();
        });
        CompletionStage reducedFuture = containerFuture.thenCombine(intermediateFuture, (containerList, intermediateSources) -> {
            MutableObject toBeReduced = new MutableObject((Object)intermediateSources.copy());
            List<CompletableFuture> reductionFutures = containerList.stream().filter(Predicate.not(ItemStack::m_41619_)).map(containerStack -> this.getAffinityValuesAsync((ItemStack)containerStack, recipeManager, registryAccess, history)).toList();
            Util.m_137567_(reductionFutures).thenAccept(valueList -> valueList.forEach(values -> toBeReduced.setValue((Object)((SourceList)toBeReduced.getValue()).remove((SourceList)values))));
            return (SourceList)toBeReduced.getValue();
        });
        return ((CompletableFuture)reducedFuture).thenApply(intermediateSources -> {
            SourceList.Builder retVal = SourceList.builder();
            intermediateSources.getSources().forEach(source -> {
                double amount = (double)intermediateSources.getAmount((Source)source) * 0.75 / (double)output.m_41613_();
                if (amount < 1.0 && amount > 0.75) {
                    amount = 1.0;
                }
                if ((int)amount > 0) {
                    retVal.with((Source)source, (int)amount);
                }
            });
            return retVal.build();
        });
    }

    @Nonnull
    protected CompletableFuture<ItemStack> getMatchingItemStackAsync(@Nullable Ingredient ingredient, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess, @Nonnull List<ResourceLocation> history) {
        if (ingredient == null || ingredient.m_43908_() == null || ingredient.m_43908_().length <= 0) {
            return CompletableFuture.completedFuture(ItemStack.f_41583_);
        }
        Map futuresMap = Stream.of(ingredient.m_43908_()).collect(Collectors.toMap(Functions.identity(), stack -> this.getAffinityValuesAsync((ItemStack)stack, recipeManager, registryAccess, history)));
        return CompletableFuture.allOf((CompletableFuture[])futuresMap.values().toArray(CompletableFuture[]::new)).thenApply($ -> {
            MutableInt maxValue = new MutableInt(Integer.MAX_VALUE);
            MutableObject retVal = new MutableObject((Object)ItemStack.f_41583_);
            futuresMap.entrySet().forEach(entry -> ((CompletableFuture)entry.getValue()).thenAccept(stackSources -> {
                int manaSize = stackSources.getManaSize();
                if (manaSize > 0 && manaSize < maxValue.intValue()) {
                    retVal.setValue((Object)((ItemStack)entry.getKey()));
                    maxValue.setValue(manaSize);
                }
            }));
            return (ItemStack)retVal.getValue();
        });
    }

    @Nullable
    protected SourceList capAffinities(@Nullable SourceList sources, int maxAmount) {
        if (sources == null) {
            return null;
        }
        SourceList retVal = SourceList.EMPTY;
        for (Source source : sources.getSources()) {
            retVal = retVal.merge(source, Math.min(maxAmount, sources.getAmount(source)));
        }
        return retVal;
    }

    @Nullable
    protected CompletableFuture<SourceList> addBonusAffinitiesAsync(@Nonnull ItemStack stack, @Nonnull SourceList inputSources, @Nonnull RecipeManager recipeManager, @Nonnull RegistryAccess registryAccess) {
        Map enchants;
        IAffinity bonus;
        ArrayList<CompletionStage> bonusFutures = new ArrayList<CompletionStage>();
        MutableObject retVal = new MutableObject((Object)inputSources.copy());
        Potion potion = PotionUtils.m_43579_((ItemStack)stack);
        if (potion != null && potion != Potions.f_43598_ && (bonus = this.getAffinity(AffinityType.POTION_BONUS, ForgeRegistries.POTIONS.getKey((Object)potion))) != null) {
            bonusFutures.add(bonus.getTotalAsync(recipeManager, registryAccess, new ArrayList<ResourceLocation>()));
        }
        if ((enchants = EnchantmentHelper.m_44831_((ItemStack)stack)) != null && !enchants.isEmpty()) {
            for (Enchantment enchant : enchants.keySet()) {
                IAffinity bonus2 = this.getAffinity(AffinityType.ENCHANTMENT_BONUS, ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant));
                if (bonus2 == null) continue;
                bonusFutures.add(bonus2.getTotalAsync(recipeManager, registryAccess, new ArrayList<ResourceLocation>()).thenApply(enchBonus -> enchBonus.multiply((Integer)enchants.get(enchant))));
            }
        }
        return Util.m_137567_(bonusFutures).thenApply(bonusList -> {
            bonusList.forEach(bonus -> retVal.setValue((Object)((SourceList)retVal.getValue()).add((SourceList)bonus)));
            return (SourceList)retVal.getValue();
        });
    }

    private static /* synthetic */ NonNullList lambda$generateItemAffinityValuesFromIngredientsAsync$20(CraftingContainer inv, CraftingRecipe craftingRecipe, List ingStackList) {
        MutableInt index = new MutableInt(0);
        ingStackList.forEach(ingStack -> {
            if (!ingStack.m_41619_()) {
                inv.m_6836_(index.intValue(), ingStack);
            }
        });
        return craftingRecipe.m_7457_((Container)inv);
    }

    protected record RecipeValues(Optional<ResourceLocation> recipe, SourceList values) {
        public static final RecipeValues EMPTY = new RecipeValues(Optional.empty(), SourceList.EMPTY);
    }
}

