/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.armortrim;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class TrimMaterialsPM {
    protected static final Map<ResourceKey<TrimMaterial>, Source> SOURCE_MAPPING = new HashMap<ResourceKey<TrimMaterial>, Source>();
    public static final ResourceKey<TrimMaterial> RUNE_EARTH = TrimMaterialsPM.registryKey("rune_earth", Source.EARTH);
    public static final ResourceKey<TrimMaterial> RUNE_SEA = TrimMaterialsPM.registryKey("rune_sea", Source.SEA);
    public static final ResourceKey<TrimMaterial> RUNE_SKY = TrimMaterialsPM.registryKey("rune_sky", Source.SKY);
    public static final ResourceKey<TrimMaterial> RUNE_SUN = TrimMaterialsPM.registryKey("rune_sun", Source.SUN);
    public static final ResourceKey<TrimMaterial> RUNE_MOON = TrimMaterialsPM.registryKey("rune_moon", Source.MOON);
    public static final ResourceKey<TrimMaterial> RUNE_BLOOD = TrimMaterialsPM.registryKey("rune_blood", Source.BLOOD);
    public static final ResourceKey<TrimMaterial> RUNE_INFERNAL = TrimMaterialsPM.registryKey("rune_infernal", Source.INFERNAL);
    public static final ResourceKey<TrimMaterial> RUNE_VOID = TrimMaterialsPM.registryKey("rune_void", Source.VOID);
    public static final ResourceKey<TrimMaterial> RUNE_HALLOWED = TrimMaterialsPM.registryKey("rune_hallowed", Source.HALLOWED);

    private static ResourceKey<TrimMaterial> registryKey(String name, Source source) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_266076_, (ResourceLocation)PrimalMagick.resource(name));
        if (SOURCE_MAPPING.containsKey(key)) {
            throw new IllegalStateException("Source mapping already set for trim material " + name);
        }
        SOURCE_MAPPING.put((ResourceKey<TrimMaterial>)key, source);
        return key;
    }

    private static void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> materialKey, Item item, Style textStyle, float itemModelIndex) {
        context.m_255272_(materialKey, (Object)TrimMaterial.m_267605_((String)materialKey.m_135782_().m_135815_(), (Item)item, (float)itemModelIndex, (Component)Component.m_237115_((String)Util.m_137492_((String)"trim_material", (ResourceLocation)materialKey.m_135782_())).m_130948_(textStyle), Map.of()));
    }

    private static Style getStyle(Source source) {
        return Style.f_131099_.m_178520_(source.getColor());
    }

    public static Source getSource(ResourceKey<TrimMaterial> key) {
        if (!SOURCE_MAPPING.containsKey(key)) {
            throw new IllegalArgumentException("No source mapping found for trim material " + key.toString());
        }
        return SOURCE_MAPPING.get(key);
    }

    public static void bootstrap(BootstapContext<TrimMaterial> context) {
        TrimMaterialsPM.register(context, RUNE_EARTH, (Item)ItemsPM.RUNE_EARTH.get(), TrimMaterialsPM.getStyle(Source.EARTH), 0.7f);
        TrimMaterialsPM.register(context, RUNE_SEA, (Item)ItemsPM.RUNE_SEA.get(), TrimMaterialsPM.getStyle(Source.SEA), 0.9f);
        TrimMaterialsPM.register(context, RUNE_SKY, (Item)ItemsPM.RUNE_SKY.get(), TrimMaterialsPM.getStyle(Source.SKY), 0.8f);
        TrimMaterialsPM.register(context, RUNE_SUN, (Item)ItemsPM.RUNE_SUN.get(), TrimMaterialsPM.getStyle(Source.SUN), 0.6f);
        TrimMaterialsPM.register(context, RUNE_MOON, (Item)ItemsPM.RUNE_MOON.get(), TrimMaterialsPM.getStyle(Source.MOON), 0.2f);
        TrimMaterialsPM.register(context, RUNE_BLOOD, (Item)ItemsPM.RUNE_BLOOD.get(), TrimMaterialsPM.getStyle(Source.BLOOD), 0.4f);
        TrimMaterialsPM.register(context, RUNE_INFERNAL, (Item)ItemsPM.RUNE_INFERNAL.get(), TrimMaterialsPM.getStyle(Source.INFERNAL), 0.5f);
        TrimMaterialsPM.register(context, RUNE_VOID, (Item)ItemsPM.RUNE_VOID.get(), TrimMaterialsPM.getStyle(Source.VOID), 1.0f);
        TrimMaterialsPM.register(context, RUNE_HALLOWED, (Item)ItemsPM.RUNE_HALLOWED.get(), TrimMaterialsPM.getStyle(Source.HALLOWED), 0.1f);
    }
}

