/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.devices;

import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.devices.WindGeneratorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractWindGeneratorBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public AbstractWindGeneratorBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83144_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
        if (!level.f_46443_ && (powered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != level.m_276867_(pos)) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WindGeneratorTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return AbstractWindGeneratorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.WIND_GENERATOR.get()), WindGeneratorTileEntity::tick);
    }

    public abstract Direction getWindDirection(BlockState var1);

    public abstract ParticleOptions getParticleType();

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            double lifetime = 20.0;
            int power = level.m_277086_(pos);
            Direction windDir = this.getWindDirection(state);
            Vec3i velocity = windDir.m_122436_().m_142393_(power);
            Vec3 start = this.getParticleStartPoint(state, level, pos, random);
            level.m_7106_(this.getParticleType(), start.f_82479_, start.f_82480_, start.f_82481_, (double)velocity.m_123341_() / lifetime, (double)velocity.m_123342_() / lifetime, (double)velocity.m_123343_() / lifetime);
        }
    }

    protected Vec3 getParticleStartPoint(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        Vec3 dirUnit = new Vec3((double)dir.m_122436_().m_123341_(), (double)dir.m_122436_().m_123342_(), (double)dir.m_122436_().m_123343_());
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        Vec3 retVal = center.m_82549_(dirUnit.m_82490_(0.5));
        for (Direction.Axis axis : Direction.Axis.values()) {
            Direction deltaDir = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Vec3 normal = new Vec3(deltaDir.m_253071_()).m_82490_(random.m_188500_() - 0.5);
            retVal = retVal.m_82549_(normal);
        }
        return retVal;
    }

    public abstract int getCoreColor();
}

