/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.devices;

import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.devices.EssenceCaskTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class EssenceCaskBlock
extends BaseEntityBlock
implements ITieredDevice {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    protected final DeviceTier tier;

    public EssenceCaskBlock(DeviceTier tier) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_));
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EssenceCaskTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return EssenceCaskBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.ESSENCE_CASK.get()), EssenceCaskTileEntity::tick);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof EssenceCaskTileEntity) {
                EssenceCaskTileEntity caskTile = (EssenceCaskTileEntity)tile;
                caskTile.dropContents();
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof EssenceCaskTileEntity) {
                EssenceCaskTileEntity caskTile = (EssenceCaskTileEntity)tile;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)caskTile, (BlockPos)tile.m_58899_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213897_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        BlockEntity tile = serverLevel.m_7702_(pos);
        if (tile instanceof EssenceCaskTileEntity) {
            EssenceCaskTileEntity caskTile = (EssenceCaskTileEntity)tile;
            caskTile.recheckOpen();
        }
    }
}

