/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.devices;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.blocks.misc.GlowFieldBlock;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.devices.SunlampTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SunlampBlock
extends BaseEntityBlock {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final DirectionProperty ATTACHMENT = DirectionProperty.m_61549_((String)"attachment", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP, Direction.DOWN});
    protected static final VoxelShape GROUND_SHAPE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/sunlamp_ground_base"));
    protected static final VoxelShape HANGING_SHAPE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/sunlamp_hanging_base"));
    protected final Supplier<GlowFieldBlock> glowSupplier;

    public SunlampBlock(Supplier<GlowFieldBlock> glowSupplier) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_278166_(PushReaction.DESTROY).m_60978_(3.5f).m_60918_(SoundType.f_56762_).m_60953_(state -> 15).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ATTACHMENT, (Comparable)Direction.DOWN));
        this.glowSupplier = glowSupplier;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)ATTACHMENT) == Direction.DOWN ? GROUND_SHAPE : HANGING_SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ATTACHMENT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)ATTACHMENT, (Comparable)context.m_43719_().m_122424_());
        return state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? state : null;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)ATTACHMENT);
        return Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_121945_(dir), (Direction)dir.m_122424_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn.m_61143_((Property)ATTACHMENT) == facing && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SunlampTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SunlampBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.SUNLAMP.get()), SunlampTileEntity::tick);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        for (int x = -15; x <= 15; ++x) {
            for (int y = -15; y <= 15; ++y) {
                for (int z = -15; z <= 15; ++z) {
                    BlockPos bp = pos.m_7918_(x, y, z);
                    if (worldIn.m_8055_(bp) != ((GlowFieldBlock)((Object)BlocksPM.GLOW_FIELD.get())).m_49966_()) continue;
                    worldIn.m_7471_(bp, false);
                }
            }
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public GlowFieldBlock getGlowField() {
        return this.glowSupplier.get();
    }
}

