/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.golems;

import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.entities.companions.golems.AbstractEnchantedGolemEntity;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractEnchantedGolemControllerBlock<T extends AbstractEnchantedGolemEntity>
extends Block
implements IInteractWithWand {
    protected static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    @Nullable
    private BlockPattern golemPattern;

    public AbstractEnchantedGolemControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract SimpleResearchKey getRequiredResearch();

    protected abstract EntityType<T> getEntityType();

    protected abstract Block getBaseBlock();

    protected abstract Block getControllerBlock();

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Override
    public InteractionResult onWandRightClick(ItemStack wandStack, Level world, Player player, BlockPos pos, Direction direction) {
        if (!world.f_46443_ && wandStack.m_41720_() instanceof IWand && this.getRequiredResearch().isKnownByStrict(player)) {
            BlockPattern.BlockPatternMatch helper = this.getGolemPattern().m_61184_((LevelReader)world, pos);
            if (helper != null) {
                for (int i = 0; i < this.getGolemPattern().m_61203_(); ++i) {
                    for (int j = 0; j < this.getGolemPattern().m_61202_(); ++j) {
                        BlockInWorld info = helper.m_61229_(i, j, 0);
                        world.m_7731_(info.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                        world.m_46796_(2001, info.m_61176_(), Block.m_49956_((BlockState)info.m_61168_()));
                    }
                }
                BlockPos blockpos = helper.m_61229_(1, 2, 0).m_61176_();
                AbstractEnchantedGolemEntity golem = (AbstractEnchantedGolemEntity)this.getEntityType().m_20615_(world);
                CompanionManager.addCompanion(player, golem);
                golem.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
                world.m_7967_((Entity)golem);
                for (int i = 0; i < this.getGolemPattern().m_61203_(); ++i) {
                    for (int j = 0; j < this.getGolemPattern().m_61202_(); ++j) {
                        BlockInWorld info = helper.m_61229_(i, j, 0);
                        world.m_6289_(info.m_61176_(), Blocks.f_50016_);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onWandUseTick(ItemStack wandStack, Level level, Player player, Vec3 targetPos, int count) {
    }

    protected BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "###", "~#~"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)this.getControllerBlock()))).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)this.getBaseBlock()))).m_61244_('~', b -> b.m_61168_().m_60795_()).m_61249_();
        }
        return this.golemPattern;
    }
}

