/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.mana;

import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.sources.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractManaFontBlock
extends BaseEntityBlock
implements ITieredDevice {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final Map<DeviceTier, List<AbstractManaFontBlock>> REGISTRY = new HashMap<DeviceTier, List<AbstractManaFontBlock>>();
    protected Source source;
    protected DeviceTier tier;

    public AbstractManaFontBlock(Source source, DeviceTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.source = source;
        this.tier = tier;
        REGISTRY.computeIfAbsent(tier, t -> new ArrayList()).add(this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public Source getSource() {
        return this.source;
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }

    public String getTierDescriptor() {
        return switch (this.tier) {
            case DeviceTier.BASIC -> "ancient";
            case DeviceTier.ENCHANTED -> "artificial";
            default -> this.tier.m_7912_();
        };
    }

    public int getManaCapacity() {
        return switch (this.tier) {
            case DeviceTier.BASIC, DeviceTier.FORBIDDEN -> 100;
            case DeviceTier.ENCHANTED -> 10;
            case DeviceTier.HEAVENLY -> 1000;
            default -> 0;
        };
    }

    public static Collection<AbstractManaFontBlock> getAllManaFontsForTier(DeviceTier tier) {
        return Collections.unmodifiableList(REGISTRY.getOrDefault((Object)tier, List.of()));
    }
}

