/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.mana;

import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.sources.ManaContainerHelper;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.mana.ManaBatteryTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class ManaBatteryBlock
extends BaseEntityBlock
implements ITieredDevice {
    protected final DeviceTier tier;

    public ManaBatteryBlock(DeviceTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ManaBatteryTileEntity(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ManaBatteryBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.MANA_BATTERY.get()), ManaBatteryTileEntity::tick);
    }

    public void m_5871_(ItemStack pStack, BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        ManaContainerHelper.appendHoverText(pStack, pTooltip);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_ && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            BlockEntity tile = pLevel.m_7702_(pPos);
            if (tile instanceof ManaBatteryTileEntity) {
                ManaBatteryTileEntity batteryTile = (ManaBatteryTileEntity)tile;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)batteryTile, (BlockPos)tile.m_58899_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        ManaContainerHelper.setManaOnPlace(pLevel, pPos, pStack);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.m_60734_() != pNewState.m_60734_()) {
            BlockEntity tile = pLevel.m_7702_(pPos);
            if (tile instanceof ManaBatteryTileEntity) {
                ManaBatteryTileEntity batteryTile = (ManaBatteryTileEntity)tile;
                batteryTile.dropContents(pLevel, pPos);
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }
}

