/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.minerals;

import com.verdantartifice.primalmagick.common.blocks.minerals.BuddingGemClusterBlock;
import com.verdantartifice.primalmagick.common.blocks.minerals.GemBudType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class BuddingGemSourceBlock
extends Block {
    protected static final int GROWTH_CHANCE = 5;
    protected final GemBudType gemType;
    protected final Supplier<BuddingGemClusterBlock> initialBudSupplier;
    protected final Supplier<Block> decayBlockSupplier;
    protected final float decayChance;

    public BuddingGemSourceBlock(GemBudType gemType, Supplier<BuddingGemClusterBlock> initialBudSupplier, Supplier<Block> decayBlockSupplier, float decayChance, BlockBehaviour.Properties properties) {
        super(properties);
        this.gemType = gemType;
        this.initialBudSupplier = initialBudSupplier;
        this.decayBlockSupplier = decayBlockSupplier;
        this.decayChance = decayChance;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188503_(5) == 0) {
            Direction dir = Direction.values()[pRandom.m_188503_(Direction.values().length)];
            BlockPos targetPos = pPos.m_121945_(dir);
            BlockState targetState = pLevel.m_8055_(targetPos);
            BuddingGemClusterBlock newCluster = null;
            if (targetState.m_60795_() || targetState.m_60713_(Blocks.f_49990_) && targetState.m_60819_().m_76186_() == 8) {
                newCluster = this.initialBudSupplier.get();
            } else {
                BuddingGemClusterBlock cluster;
                Block block = targetState.m_60734_();
                if (block instanceof BuddingGemClusterBlock && (cluster = (BuddingGemClusterBlock)block).getGemBudType() == this.gemType && targetState.m_61143_((Property)BuddingGemClusterBlock.FACING) == dir && cluster.getNextGemBlock().isPresent()) {
                    newCluster = cluster.getNextGemBlock().get().get();
                }
            }
            if (newCluster != null) {
                BlockState newClusterState = (BlockState)((BlockState)newCluster.m_49966_().m_61124_((Property)BuddingGemClusterBlock.FACING, (Comparable)dir)).m_61124_((Property)BuddingGemClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(targetState.m_60819_().m_76152_() == Fluids.f_76193_));
                pLevel.m_46597_(targetPos, newClusterState);
                if (pRandom.m_188501_() < this.decayChance) {
                    pLevel.m_46597_(pPos, this.decayBlockSupplier.get().m_49966_());
                }
            }
        }
    }

    @Nullable
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

