/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderwardBlock
extends Block {
    public static final int EFFECT_RADIUS = 16;
    protected static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape BASE_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> AABBS = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.builder().put((Object)Direction.NORTH, (Object)BASE_AABB).put((Object)Direction.SOUTH, (Object)VoxelShapeUtils.rotate(BASE_AABB, Direction.Axis.Y, Rotation.CLOCKWISE_180)).put((Object)Direction.WEST, (Object)VoxelShapeUtils.rotate(BASE_AABB, Direction.Axis.Y, Rotation.CLOCKWISE_90)).put((Object)Direction.EAST, (Object)VoxelShapeUtils.rotate(BASE_AABB, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90)).build());

    public EnderwardBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_60966_().m_278166_(PushReaction.DESTROY).m_60918_(SoundType.f_56736_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABBS.getOrDefault(pState.m_61143_((Property)FACING), BASE_AABB);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        BlockPos blockPos = pPos.m_121945_(direction.m_122424_());
        BlockState blockState = pLevel.m_8055_(blockPos);
        return blockState.m_60783_((BlockGetter)pLevel, blockPos, direction);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction[] directions;
        BlockState blockState = this.m_49966_();
        Level levelReader = pContext.m_43725_();
        BlockPos blockPos = pContext.m_8083_();
        for (Direction dir : directions = pContext.m_6232_()) {
            Direction oppositeDir;
            if (!dir.m_122434_().m_122479_() || !(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)(oppositeDir = dir.m_122424_()))).m_60710_((LevelReader)levelReader, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return pDirection.m_122424_() == pState.m_61143_((Property)FACING) && !pState.m_60710_((LevelReader)pLevel, pPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction stepDir = ((Direction)pState.m_61143_((Property)FACING)).m_122424_();
        for (int i = 0; i < 3; ++i) {
            int j = pRandom.m_188503_(2) * 2 - 1;
            int k = pRandom.m_188503_(2) * 2 - 1;
            int l = pRandom.m_188503_(2) * 2 - 1;
            double d0 = (double)pPos.m_123341_() + 0.5 + (double)stepDir.m_122429_() * 0.4375 + 0.125 * (double)j;
            double d1 = (double)pPos.m_123342_() + 0.5 + 0.125 * (double)k;
            double d2 = (double)pPos.m_123343_() + 0.5 + (double)stepDir.m_122431_() * 0.4375 + 0.125 * (double)l;
            double d3 = pRandom.m_188501_() * (float)j;
            double d4 = pRandom.m_188501_() * (float)k;
            double d5 = pRandom.m_188501_() * (float)l;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }
}

