/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PillarBlock
extends Block {
    protected static final VoxelShape SHAPE_BASE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/pillar"));
    protected static final VoxelShape SHAPE_BOTTOM = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/pillar_bottom"));
    protected static final VoxelShape SHAPE_TOP = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/pillar_top"));
    public static final EnumProperty<Type> PROPERTY_TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public PillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PROPERTY_TYPE, (Comparable)((Object)Type.BASE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Type)((Object)state.m_61143_(PROPERTY_TYPE))) {
            case BOTTOM: {
                return SHAPE_BOTTOM;
            }
            case TOP: {
                return SHAPE_TOP;
            }
        }
        return SHAPE_BASE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getCurrentState((LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getCurrentState(worldIn, currentPos);
    }

    protected BlockState getCurrentState(LevelAccessor world, BlockPos pos) {
        boolean up = world.m_8055_(pos.m_7494_()).m_60734_() instanceof PillarBlock;
        boolean down = world.m_8055_(pos.m_7495_()).m_60734_() instanceof PillarBlock;
        if (up && down) {
            return (BlockState)this.m_49966_().m_61124_(PROPERTY_TYPE, (Comparable)((Object)Type.BASE));
        }
        if (up) {
            return (BlockState)this.m_49966_().m_61124_(PROPERTY_TYPE, (Comparable)((Object)Type.BOTTOM));
        }
        if (down) {
            return (BlockState)this.m_49966_().m_61124_(PROPERTY_TYPE, (Comparable)((Object)Type.TOP));
        }
        return (BlockState)this.m_49966_().m_61124_(PROPERTY_TYPE, (Comparable)((Object)Type.BASE));
    }

    public static enum Type implements StringRepresentable
    {
        BASE("base"),
        BOTTOM("bottom"),
        TOP("top");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

