/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.google.common.collect.Maps;
import com.verdantartifice.primalmagick.common.blockstates.properties.SkyglassPaneSide;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyglassPaneBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SkyglassPaneSide> NORTH = EnumProperty.m_61587_((String)"north", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> EAST = EnumProperty.m_61587_((String)"east", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> SOUTH = EnumProperty.m_61587_((String)"south", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> WEST = EnumProperty.m_61587_((String)"west", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> UP = EnumProperty.m_61587_((String)"up", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> DOWN = EnumProperty.m_61587_((String)"down", SkyglassPaneSide.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, EnumProperty<SkyglassPaneSide>> FACING_TO_PROPERTY_MAP = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
    });
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    protected final Object2IntMap<BlockState> stateShapeIndices = new Object2IntOpenHashMap();

    public SkyglassPaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
        this.collisionShapes = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)((Object)SkyglassPaneSide.NONE))).m_61124_(EAST, (Comparable)((Object)SkyglassPaneSide.NONE))).m_61124_(SOUTH, (Comparable)((Object)SkyglassPaneSide.NONE))).m_61124_(WEST, (Comparable)((Object)SkyglassPaneSide.NONE))).m_61124_(UP, (Comparable)((Object)SkyglassPaneSide.NONE))).m_61124_(DOWN, (Comparable)((Object)SkyglassPaneSide.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float extensionWidth, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < avoxelshape.length; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        ToIntFunction<BlockState> mappingFunction = s -> {
            int index = 0;
            if (s.m_61143_(NORTH) == SkyglassPaneSide.GLASS || s.m_61143_(NORTH) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.NORTH);
            }
            if (s.m_61143_(SOUTH) == SkyglassPaneSide.GLASS || s.m_61143_(SOUTH) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.SOUTH);
            }
            if (s.m_61143_(WEST) == SkyglassPaneSide.GLASS || s.m_61143_(WEST) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.WEST);
            }
            if (s.m_61143_(EAST) == SkyglassPaneSide.GLASS || s.m_61143_(EAST) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.EAST);
            }
            return index;
        };
        return this.stateShapeIndices.computeIfAbsent((Object)state, mappingFunction);
    }

    protected static int getDirectionMask(Direction dir) {
        return 1 << dir.m_122416_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getCurrentState(this.m_49966_(), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return this.getCurrentState(stateIn, worldIn, currentPos);
    }

    protected BlockState getCurrentState(BlockState state, LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(UP, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.UP)))).m_61124_(DOWN, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.DOWN)))).m_61124_(NORTH, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.NORTH)))).m_61124_(SOUTH, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.SOUTH)))).m_61124_(WEST, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.WEST)))).m_61124_(EAST, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    protected SkyglassPaneSide getSideConnection(BlockState state, LevelAccessor world, BlockPos pos, Direction dir) {
        BlockState adjacent = world.m_8055_(pos.m_121945_(dir));
        if (adjacent == null || SkyglassPaneBlock.m_152463_((BlockState)adjacent)) {
            return SkyglassPaneSide.NONE;
        }
        if (state.m_60734_() == adjacent.m_60734_()) {
            return SkyglassPaneSide.GLASS;
        }
        if (adjacent.m_60783_((BlockGetter)world, pos.m_121945_(dir), dir.m_122424_()) || adjacent.m_60734_() instanceof SkyglassPaneBlock) {
            return SkyglassPaneSide.OTHER;
        }
        return SkyglassPaneSide.NONE;
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (adjacentBlockState.m_60734_() == state.m_60734_()) {
            if (!side.m_122434_().m_122479_()) {
                return true;
            }
            if (state.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(side)) == SkyglassPaneSide.GLASS && adjacentBlockState.m_61143_((Property)FACING_TO_PROPERTY_MAP.get(side.m_122424_())) == SkyglassPaneSide.GLASS) {
                return true;
            }
        }
        return super.m_6104_(state, adjacentBlockState, side);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(WEST)))))).m_61124_(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(NORTH)))))).m_61124_(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(EAST)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(WEST)))))).m_61124_(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(SOUTH)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(EAST)))))).m_61124_(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(NORTH)))));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.m_61143_(EAST)))));
            }
        }
        return state;
    }
}

