/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.EntropySinkTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntropySinkBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final VoxelShape SHAPE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/entropy_sink"));

    public EntropySinkBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60978_(3.5f).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0).m_60918_(SoundType.f_56742_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, LIT});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EntropySinkTileEntity(pos, state);
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), Color.WHITE.getRGB());
        }
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.625 * rand.m_188500_() + 0.1875;
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.625 * rand.m_188500_() + 0.1875;
            worldIn.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        EntropySinkTileEntity sink;
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity instanceof EntropySinkTileEntity && (sink = (EntropySinkTileEntity)blockEntity).isGlowing();
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.entropy_sink";
    }

    public float getUsageStabilityBonus(EssenceItem item) {
        return item.getEssenceType().getAffinity();
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (player != null && stack.m_41720_() instanceof EssenceItem && !this.isPropActivated(state, worldIn, pos)) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (!worldIn.f_46443_ && tile instanceof EntropySinkTileEntity) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.TRUE), 11);
                ((EntropySinkTileEntity)tile).startGlowing();
                if (this.isPropOpen(state, worldIn, pos)) {
                    this.onPropActivated(state, worldIn, pos, this.getUsageStabilityBonus((EssenceItem)stack.m_41720_()));
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (stack.m_41613_() <= 0) {
                        player.m_21008_(handIn, ItemStack.f_41583_);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            this.closeProp(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return EntropySinkBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.ENTROPY_SINK.get()), EntropySinkTileEntity::tick);
    }

    @Override
    public boolean isUniversal() {
        return true;
    }
}

