/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.rituals.IncenseBrazierTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IncenseBrazierBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final VoxelShape SHAPE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/incense_brazier"));

    public IncenseBrazierBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 7 : 0));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.8;
            double z = (double)pos.m_123343_() + 0.65;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        }
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), Color.WHITE.getRGB());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player != null && player.m_21120_(handIn).m_41720_() == ItemsPM.INCENSE_STICK.get() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_5594_(player, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.TRUE), 11);
                if (!player.m_150110_().f_35937_) {
                    player.m_21120_(handIn).m_41774_(1);
                    if (player.m_21120_(handIn).m_41613_() <= 0) {
                        player.m_21008_(handIn, ItemStack.f_41583_);
                    }
                }
                if (this.isPropOpen(state, worldIn, pos)) {
                    this.onPropActivated(state, worldIn, pos, this.getUsageStabilityBonus());
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.m_21120_(handIn).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.FALSE), 11);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            this.closeProp(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new IncenseBrazierTileEntity(pos, state);
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.01f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.01f;
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        return state != null && state.m_61138_((Property)LIT) && (Boolean)state.m_61143_((Property)LIT) != false;
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.incense_brazier";
    }

    public float getUsageStabilityBonus() {
        return 5.0f;
    }
}

