/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.tiles.rituals.OfferingPedestalTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OfferingPedestalBlock
extends BaseEntityBlock
implements ISaltPowered,
IRitualStabilizer {
    protected static final VoxelShape SHAPE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/offering_pedestal"));

    public OfferingPedestalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_).m_60955_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), Color.WHITE.getRGB());
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OfferingPedestalTileEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile;
        if (handIn == InteractionHand.MAIN_HAND && (tile = worldIn.m_7702_(pos)) instanceof OfferingPedestalTileEntity) {
            OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
            if (pedestalTile.getItem().m_41619_() && !player.m_21120_(handIn).m_41619_()) {
                ItemStack stack = player.m_21120_(handIn).m_41777_();
                stack.m_41764_(1);
                pedestalTile.setItem(stack);
                player.m_21120_(handIn).m_41774_(1);
                if (player.m_21120_(handIn).m_41613_() <= 0) {
                    player.m_21008_(handIn, ItemStack.f_41583_);
                }
                player.m_150109_().m_6596_();
                worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!pedestalTile.getItem().m_41619_() && player.m_21120_(handIn).m_41619_()) {
                ItemStack stack = pedestalTile.getItem().m_41777_();
                pedestalTile.setItem(ItemStack.f_41583_);
                player.m_21008_(handIn, stack);
                player.m_150109_().m_6596_();
                worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSymmetryPenalty(Level world, BlockPos pos, BlockPos otherPos) {
        BlockEntity tile = world.m_7702_(pos);
        BlockEntity otherTile = world.m_7702_(otherPos);
        if (tile instanceof OfferingPedestalTileEntity) {
            if (!(otherTile instanceof OfferingPedestalTileEntity)) return true;
        }
        if (!(tile instanceof OfferingPedestalTileEntity) && otherTile instanceof OfferingPedestalTileEntity) {
            return true;
        }
        if (world.f_46443_) {
            if (!(tile instanceof OfferingPedestalTileEntity)) return false;
            OfferingPedestalTileEntity pedestal = (OfferingPedestalTileEntity)tile;
            if (!(otherTile instanceof OfferingPedestalTileEntity)) return false;
            OfferingPedestalTileEntity otherPedestal = (OfferingPedestalTileEntity)otherTile;
            if (pedestal.getSyncedStack().m_41619_() == otherPedestal.getSyncedStack().m_41619_()) return false;
            return true;
        }
        if (!(tile instanceof OfferingPedestalTileEntity)) return false;
        OfferingPedestalTileEntity pedestal = (OfferingPedestalTileEntity)tile;
        if (!(otherTile instanceof OfferingPedestalTileEntity)) return false;
        OfferingPedestalTileEntity otherPedestal = (OfferingPedestalTileEntity)otherTile;
        if (pedestal.getItem().m_41619_() == otherPedestal.getItem().m_41619_()) return false;
        return true;
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.01f;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof OfferingPedestalTileEntity) {
                OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
                pedestalTile.dropContents(worldIn, pos);
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }
}

