/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualAltarTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class RitualAltarBlock
extends BaseEntityBlock
implements ISaltPowered {
    public RitualAltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283942_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56742_).m_60955_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        for (Direction dir : Direction.values()) {
            worldIn.m_46672_(pos.m_121945_(dir), (Block)this);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!isMoving) {
            for (Direction dir : Direction.values()) {
                worldIn.m_46672_(pos.m_121945_(dir), (Block)this);
            }
        }
        if (state.m_60734_() != newState.m_60734_() && (tile = worldIn.m_7702_(pos)) instanceof RitualAltarTileEntity) {
            RitualAltarTileEntity altarTile = (RitualAltarTileEntity)tile;
            altarTile.dropContents(worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public int getMaxSaltPower() {
        return 15;
    }

    public int getMaxSafeSalt() {
        return 16;
    }

    @Override
    public int getStrongSaltPower(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return side != Direction.UP ? this.getMaxSaltPower() : 0;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualAltarTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RitualAltarBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.RITUAL_ALTAR.get()), RitualAltarTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        RitualAltarTileEntity altarTile;
        BlockEntity tile;
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND && (tile = worldIn.m_7702_(pos)) instanceof RitualAltarTileEntity && !(altarTile = (RitualAltarTileEntity)tile).getItem().m_41619_() && player.m_21120_(handIn).m_41619_()) {
            ItemStack stack = altarTile.getItem().m_41777_();
            altarTile.setItem(ItemStack.f_41583_);
            player.m_21008_(handIn, stack);
            player.m_150109_().m_6596_();
            worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }
}

