/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.google.common.collect.Maps;
import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualBellTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualBellBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.f_61377_;
    protected static final VoxelShape BELL_CORE_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0));
    protected static final VoxelShape FLOOR_SHAPE = Shapes.m_83110_((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(PrimalMagick.resource("block/ritual_bell_floor")));
    protected static final VoxelShape CEILING_SHAPE = Shapes.m_83110_((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(PrimalMagick.resource("block/ritual_bell_ceiling")));
    protected static final VoxelShape ONE_WALL_SHAPE = Shapes.m_83110_((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(PrimalMagick.resource("block/ritual_bell_wall")));
    protected static final VoxelShape TWO_WALLS_SHAPE = Shapes.m_83110_((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(PrimalMagick.resource("block/ritual_bell_between_walls")));
    protected static final Map<BellAttachType, Map<Direction, VoxelShape>> SHAPES = (Map)Util.m_137469_((Object)Maps.newEnumMap(BellAttachType.class), map -> {
        map.put(BellAttachType.FLOOR, (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, FLOOR_SHAPE);
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(FLOOR_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(FLOOR_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.EAST, VoxelShapeUtils.rotate(FLOOR_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
        }));
        map.put(BellAttachType.CEILING, (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, CEILING_SHAPE);
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(CEILING_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(CEILING_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.EAST, VoxelShapeUtils.rotate(CEILING_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
        }));
        map.put(BellAttachType.SINGLE_WALL, (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, VoxelShapeUtils.rotate(ONE_WALL_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(ONE_WALL_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(ONE_WALL_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.EAST, ONE_WALL_SHAPE);
        }));
        map.put(BellAttachType.DOUBLE_WALL, (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, VoxelShapeUtils.rotate(TWO_WALLS_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(TWO_WALLS_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(TWO_WALLS_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.EAST, TWO_WALLS_SHAPE);
        }));
    });

    public RitualBellBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283772_).m_278166_(PushReaction.DESTROY).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56749_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(ATTACHMENT, (Comparable)BellAttachType.FLOOR));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ATTACHMENT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BellAttachType attachment = (BellAttachType)state.m_61143_(ATTACHMENT);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        return SHAPES.getOrDefault(attachment, Collections.emptyMap()).getOrDefault(facing, BELL_CORE_SHAPE);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected static Direction getAttachmentDirection(BlockState state) {
        switch ((BellAttachType)state.m_61143_(ATTACHMENT)) {
            case FLOOR: {
                return Direction.DOWN;
            }
            case CEILING: {
                return Direction.UP;
            }
        }
        return (Direction)state.m_61143_((Property)FACING);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = RitualBellBlock.getAttachmentDirection(state);
        return direction == Direction.UP ? Block.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)worldIn, (BlockPos)pos, (Direction)direction);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Direction.Axis axis = direction.m_122434_();
        if (axis == Direction.Axis.Y) {
            BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_());
            if (blockstate.m_60710_((LevelReader)context.m_43725_(), blockpos)) {
                return blockstate;
            }
        } else {
            boolean flag = axis == Direction.Axis.X && world.m_8055_(blockpos.m_122024_()).m_60783_((BlockGetter)world, blockpos.m_122024_(), Direction.EAST) && world.m_8055_(blockpos.m_122029_()).m_60783_((BlockGetter)world, blockpos.m_122029_(), Direction.WEST) || axis == Direction.Axis.Z && world.m_8055_(blockpos.m_122012_()).m_60783_((BlockGetter)world, blockpos.m_122012_(), Direction.SOUTH) && world.m_8055_(blockpos.m_122019_()).m_60783_((BlockGetter)world, blockpos.m_122019_(), Direction.NORTH);
            BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_(ATTACHMENT, (Comparable)(flag ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockstate1.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
                return blockstate1;
            }
            boolean flag1 = world.m_8055_(blockpos.m_7495_()).m_60783_((BlockGetter)world, blockpos.m_7495_(), Direction.UP);
            if ((blockstate1 = (BlockState)blockstate1.m_61124_(ATTACHMENT, (Comparable)(flag1 ? BellAttachType.FLOOR : BellAttachType.CEILING))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
                return blockstate1;
            }
        }
        return null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BellAttachType attachment = (BellAttachType)stateIn.m_61143_(ATTACHMENT);
        Direction direction = RitualBellBlock.getAttachmentDirection(stateIn);
        if (direction == facing && !stateIn.m_60710_((LevelReader)worldIn, currentPos) && attachment != BellAttachType.DOUBLE_WALL) {
            return Blocks.f_50016_.m_49966_();
        }
        if (facing.m_122434_() == ((Direction)stateIn.m_61143_((Property)FACING)).m_122434_()) {
            if (attachment == BellAttachType.DOUBLE_WALL && !facingState.m_60783_((BlockGetter)worldIn, facingPos, facing)) {
                return (BlockState)((BlockState)stateIn.m_61124_(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).m_61124_((Property)FACING, (Comparable)facing.m_122424_());
            }
            if (attachment == BellAttachType.SINGLE_WALL && direction.m_122424_() == facing && facingState.m_60783_((BlockGetter)worldIn, facingPos, (Direction)stateIn.m_61143_((Property)FACING))) {
                return (BlockState)stateIn.m_61124_(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualBellTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RitualBellBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityTypesPM.RITUAL_BELL.get()), RitualBellTileEntity::tick);
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.m_19749_();
        Player playerentity = entity instanceof Player ? (Player)entity : null;
        this.tryRing(worldIn, state, hit, playerentity);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.tryRing(worldIn, state, hit, player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected boolean tryRing(Level world, BlockState state, BlockHitResult hit, @Nullable Player player) {
        BlockPos pos;
        Direction dir = hit.m_82434_();
        if (this.canRingFrom(state, dir, hit.m_82450_().f_82480_ - (double)(pos = hit.m_82425_()).m_123342_())) {
            this.doRing(state, world, pos, dir);
            return true;
        }
        return false;
    }

    protected void doRing(BlockState state, Level world, BlockPos pos, @Nullable Direction dir) {
        BlockEntity tile = world.m_7702_(pos);
        if (!world.f_46443_ && tile instanceof RitualBellTileEntity) {
            if (dir == null) {
                dir = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
            }
            ((RitualBellTileEntity)tile).ring(dir);
            world.m_5594_(null, pos, SoundEvents.f_11699_, SoundSource.BLOCKS, 2.0f, 1.0f);
            if (this.isPropOpen(state, world, pos)) {
                this.onPropActivated(state, world, pos, this.getUsageStabilityBonus());
            }
        }
    }

    protected boolean canRingFrom(BlockState state, Direction dir, double yPos) {
        if (dir.m_122434_() != Direction.Axis.Y && yPos <= 0.8124) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            BellAttachType attachment = (BellAttachType)state.m_61143_(ATTACHMENT);
            switch (attachment) {
                case FLOOR: {
                    return facing.m_122434_() == dir.m_122434_();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return facing.m_122434_() != dir.m_122434_();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            this.closeProp(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), Color.WHITE.getRGB());
        }
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        RitualBellTileEntity bell;
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity instanceof RitualBellTileEntity && (bell = (RitualBellTileEntity)blockEntity).isRinging();
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.ritual_bell";
    }

    public float getUsageStabilityBonus() {
        return 10.0f;
    }
}

