/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualCandleTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualCandleBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    protected static final VoxelShape SHAPE = VoxelShapeUtils.fromModel(PrimalMagick.resource("block/ritual_candle"));
    protected static final List<RitualCandleBlock> REGISTRY = new ArrayList<RitualCandleBlock>();
    protected final DyeColor color;

    public RitualCandleBlock(DyeColor colorIn, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = colorIn;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
        REGISTRY.add(this);
    }

    public DyeColor getColor() {
        return this.color;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.7;
            double z = (double)pos.m_123343_() + 0.5;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
            if (rand.m_188501_() < 0.17f) {
                worldIn.m_7785_(x, y, z, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + rand.m_188501_(), 0.3f + rand.m_188501_() * 0.7f, false);
            }
        }
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), Color.WHITE.getRGB());
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player != null && player.m_21120_(handIn).m_41720_() instanceof FlintAndSteelItem && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.m_188501_() * 0.4f);
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.TRUE), 11);
                player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(handIn));
                if (this.isPropOpen(state, worldIn, pos)) {
                    this.onPropActivated(state, worldIn, pos, this.getUsageStabilityBonus());
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.m_21120_(handIn).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            worldIn.m_5594_(player, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.f_46443_) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.FALSE), 11);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            this.closeProp(state, worldIn, pos);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualCandleTileEntity(pos, state);
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        return state != null && state.m_61138_((Property)LIT) && (Boolean)state.m_61143_((Property)LIT) != false;
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.ritual_candle";
    }

    public float getUsageStabilityBonus() {
        return 5.0f;
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.01f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.01f;
    }

    public static Collection<RitualCandleBlock> getAllCandles() {
        return Collections.unmodifiableList(REGISTRY);
    }
}

