/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.google.common.collect.Maps;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenEnchantedBookScreenPacket;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualLecternTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualLecternBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.f_61440_;
    protected static final VoxelShape BASE_AND_STAND_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0));
    protected static final VoxelShape COLLISION_SHAPE = Shapes.m_83110_((VoxelShape)BASE_AND_STAND_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0));
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.m_49796_((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), BASE_AND_STAND_SHAPE});
    protected static final Map<Direction, VoxelShape> SHAPES = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, SHAPE);
        map.put(Direction.SOUTH, VoxelShapeUtils.rotate(SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
        map.put(Direction.WEST, VoxelShapeUtils.rotate(SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
        map.put(Direction.EAST, VoxelShapeUtils.rotate(SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
    });

    public RitualLecternBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60978_(2.5f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_BOOK, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return BASE_AND_STAND_SHAPE;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.getOrDefault(state.m_61143_((Property)FACING), BASE_AND_STAND_SHAPE);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HAS_BOOK});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tile;
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND && (tile = worldIn.m_7702_(pos)) instanceof RitualLecternTileEntity) {
            RitualLecternTileEntity lecternTile = (RitualLecternTileEntity)tile;
            ItemStack bookStack = lecternTile.getItem();
            if (bookStack.m_41619_() && player.m_21120_(handIn).m_150930_(Items.f_42690_)) {
                ItemStack stack = player.m_21120_(handIn).m_255036_(1);
                lecternTile.setItem(stack);
                player.m_21120_(handIn).m_41774_(1);
                if (player.m_21120_(handIn).m_41613_() <= 0) {
                    player.m_21008_(handIn, ItemStack.f_41583_);
                }
                player.m_150109_().m_6596_();
                worldIn.m_5594_(null, pos, SoundEvents.f_11714_, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_BOOK, (Comparable)Boolean.TRUE), 3);
                if (this.isPropOpen(state, worldIn, pos)) {
                    this.onPropActivated(state, worldIn, pos, this.getUsageStabilityBonus());
                }
                return InteractionResult.SUCCESS;
            }
            if (!bookStack.m_41619_()) {
                if (player.m_36341_()) {
                    ItemStack stack = bookStack.m_41777_();
                    lecternTile.setItem(ItemStack.f_41583_);
                    if (!player.m_150109_().m_36054_(stack)) {
                        player.m_36176_(stack, false);
                    }
                    player.m_150109_().m_6596_();
                    worldIn.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.4f, 1.0f);
                    worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_BOOK, (Comparable)Boolean.FALSE), 3);
                    return InteractionResult.SUCCESS;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EnchantmentHelper.m_44831_((ItemStack)bookStack).entrySet().stream().sorted((e1, e2) -> -Integer.compare((Integer)e1.getValue(), (Integer)e2.getValue())).findFirst().ifPresent(entry -> PacketHandler.sendToPlayer(new OpenEnchantedBookScreenPacket((Enchantment)entry.getKey()), serverPlayer));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!worldIn.f_46443_ && state.m_60734_() != newState.m_60734_()) {
            this.closeProp(state, worldIn, pos);
        }
        if (state.m_60734_() != newState.m_60734_() && (tile = worldIn.m_7702_(pos)) instanceof RitualLecternTileEntity) {
            RitualLecternTileEntity lecternTile = (RitualLecternTileEntity)tile;
            lecternTile.dropContents(worldIn, pos);
            worldIn.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + rand.m_188500_(), (double)pos.m_123343_() + rand.m_188500_(), Color.WHITE.getRGB());
        }
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        return state != null && state.m_61138_((Property)HAS_BOOK) && (Boolean)state.m_61143_((Property)HAS_BOOK) != false;
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.ritual_lectern";
    }

    public float getUsageStabilityBonus() {
        return 10.0f;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RitualLecternTileEntity(pos, state);
    }
}

