/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blockstates.properties.SaltSide;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class SaltTrailBlock
extends Block
implements ISaltPowered {
    public static final EnumProperty<SaltSide> NORTH = EnumProperty.m_61587_((String)"north", SaltSide.class);
    public static final EnumProperty<SaltSide> EAST = EnumProperty.m_61587_((String)"east", SaltSide.class);
    public static final EnumProperty<SaltSide> SOUTH = EnumProperty.m_61587_((String)"south", SaltSide.class);
    public static final EnumProperty<SaltSide> WEST = EnumProperty.m_61587_((String)"west", SaltSide.class);
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"salt_power", (int)0, (int)15);
    public static final Map<Direction, EnumProperty<SaltSide>> FACING_PROPERTY_MAP = new EnumMap<Direction, EnumProperty<SaltSide>>((Map<Direction, EnumProperty<SaltSide>>)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};
    protected boolean canProvidePower = true;
    protected final Set<BlockPos> blocksNeedingUpdate = new HashSet<BlockPos>();

    public SaltTrailBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60910_().m_60978_(0.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)((Object)SaltSide.NONE))).m_61124_(EAST, (Comparable)((Object)SaltSide.NONE))).m_61124_(SOUTH, (Comparable)((Object)SaltSide.NONE))).m_61124_(WEST, (Comparable)((Object)SaltSide.NONE))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected int getAABBIndex(BlockState state) {
        boolean wConnected;
        int index = 0;
        boolean nConnected = state.m_61143_(NORTH) != SaltSide.NONE;
        boolean eConnected = state.m_61143_(EAST) != SaltSide.NONE;
        boolean sConnected = state.m_61143_(SOUTH) != SaltSide.NONE;
        boolean bl = wConnected = state.m_61143_(WEST) != SaltSide.NONE;
        if (nConnected || sConnected && !nConnected && !eConnected && !wConnected) {
            index |= 1 << Direction.NORTH.m_122416_();
        }
        if (eConnected || wConnected && !nConnected && !eConnected && !sConnected) {
            index |= 1 << Direction.EAST.m_122416_();
        }
        if (sConnected || nConnected && !eConnected && !sConnected && !wConnected) {
            index |= 1 << Direction.SOUTH.m_122416_();
        }
        if (wConnected || eConnected && !nConnected && !sConnected && !wConnected) {
            index |= 1 << Direction.WEST.m_122416_();
        }
        return index;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[this.getAABBIndex(state)];
    }

    protected boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return state.m_60734_() instanceof ISaltPowered;
    }

    @Nonnull
    protected SaltSide getSide(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction face) {
        BlockPos facePos = pos.m_121945_(face);
        BlockState faceState = world.m_8055_(facePos);
        BlockPos upPos = pos.m_7494_();
        BlockState upState = world.m_8055_(upPos);
        if (!upState.m_60796_(world, upPos)) {
            boolean isSolid = faceState.m_60783_(world, facePos, Direction.UP);
            boolean canConnectFaceUp = this.canConnectTo(world.m_8055_(facePos.m_7494_()), world, facePos.m_7494_(), null);
            if (isSolid && canConnectFaceUp) {
                if (faceState.m_60783_(world, facePos, face.m_122424_())) {
                    return SaltSide.UP;
                }
                return SaltSide.SIDE;
            }
        }
        boolean canConnectToFace = this.canConnectTo(faceState, world, facePos, face);
        boolean isFaceNormal = faceState.m_60796_(world, facePos);
        boolean canConnectFaceDown = this.canConnectTo(world.m_8055_(facePos.m_7495_()), world, facePos.m_7495_(), null);
        if (!(canConnectToFace || !isFaceNormal && canConnectFaceDown)) {
            return SaltSide.NONE;
        }
        return SaltSide.SIDE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(WEST, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.WEST)))).m_61124_(EAST, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.EAST)))).m_61124_(NORTH, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.NORTH)))).m_61124_(SOUTH, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.SOUTH)));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_(WEST, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.WEST)))).m_61124_(EAST, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.EAST)))).m_61124_(NORTH, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.NORTH)))).m_61124_(SOUTH, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.SOUTH)));
        }
        return (BlockState)stateIn.m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, facing)));
    }

    public void m_7742_(BlockState state, LevelAccessor world, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            SaltSide saltSide = (SaltSide)((Object)state.m_61143_((Property)FACING_PROPERTY_MAP.get(dir)));
            if (saltSide == SaltSide.NONE || world.m_8055_((BlockPos)mbp.m_122190_((Vec3i)pos).m_122173_(dir)).m_60734_() == this) continue;
            mbp.m_122173_(Direction.DOWN);
            BlockState downState = world.m_8055_((BlockPos)mbp);
            BlockPos oppDownPos = mbp.m_121945_(dir.m_122424_());
            BlockState newDownState = downState.m_60728_(dir.m_122424_(), world.m_8055_(oppDownPos), world, (BlockPos)mbp, oppDownPos);
            SaltTrailBlock.m_49908_((BlockState)downState, (BlockState)newDownState, (LevelAccessor)world, (BlockPos)mbp, (int)flags, (int)recursionLeft);
            mbp.m_122190_((Vec3i)pos).m_122173_(dir).m_122173_(Direction.UP);
            BlockState upState = world.m_8055_((BlockPos)mbp);
            BlockPos oppUpPos = mbp.m_121945_(dir.m_122424_());
            BlockState newUpState = upState.m_60728_(dir.m_122424_(), world.m_8055_(oppUpPos), world, (BlockPos)mbp, oppUpPos);
            SaltTrailBlock.m_49908_((BlockState)upState, (BlockState)newUpState, (LevelAccessor)world, (BlockPos)mbp, (int)flags, (int)recursionLeft);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos downPos = pos.m_7495_();
        BlockState downState = world.m_8055_(downPos);
        return downState.m_60783_((BlockGetter)world, downPos, Direction.UP);
    }

    protected int getSaltPowerFromNeighbors(Level world, BlockPos pos) {
        int maxPower = 0;
        for (Direction dir : Direction.values()) {
            int power = this.getSaltPower((BlockGetter)world, pos.m_121945_(dir), dir);
            if (power >= 15) {
                return 15;
            }
            if (power <= maxPower) continue;
            maxPower = power;
        }
        return maxPower;
    }

    protected int maxSignal(int existingSignal, BlockState neighbor) {
        if (neighbor.m_60734_() == this) {
            int power = (Integer)neighbor.m_61143_((Property)POWER);
            return Math.max(power, existingSignal);
        }
        return existingSignal;
    }

    protected BlockState updateOwnSaltPower(Level world, BlockPos pos, BlockState state) {
        int decrSignal;
        BlockState stateCopy = state;
        int curPower = (Integer)state.m_61143_((Property)POWER);
        this.canProvidePower = false;
        int neighborPower = this.getSaltPowerFromNeighbors(world, pos);
        this.canProvidePower = true;
        int signal = 0;
        if (neighborPower < 15) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.m_121945_(dir);
                BlockState offsetState = world.m_8055_(offsetPos);
                signal = this.maxSignal(signal, offsetState);
                BlockPos upPos = pos.m_7494_();
                if (offsetState.m_60796_((BlockGetter)world, offsetPos) && !world.m_8055_(upPos).m_60796_((BlockGetter)world, upPos)) {
                    signal = this.maxSignal(signal, world.m_8055_(offsetPos.m_7494_()));
                    continue;
                }
                if (offsetState.m_60796_((BlockGetter)world, offsetPos)) continue;
                signal = this.maxSignal(signal, world.m_8055_(offsetPos.m_7495_()));
            }
        }
        if (neighborPower > (decrSignal = signal - 1)) {
            decrSignal = neighborPower;
        }
        if (curPower != decrSignal) {
            state = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(decrSignal));
            if (world.m_8055_(pos) == stateCopy) {
                world.m_7731_(pos, state, 2);
            }
            this.blocksNeedingUpdate.add(pos);
            for (Direction dir : Direction.values()) {
                this.blocksNeedingUpdate.add(pos.m_121945_(dir));
            }
        }
        return state;
    }

    protected BlockState updateSurroundingSaltPower(Level world, BlockPos pos, BlockState state) {
        state = this.updateOwnSaltPower(world, pos, state);
        ArrayList<BlockPos> updateList = new ArrayList<BlockPos>(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos updatePos : updateList) {
            world.m_46672_(updatePos, (Block)this);
        }
        return state;
    }

    protected void notifyTrailNeighborsOfStateChange(Level world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() == this) {
            world.m_46672_(pos, (Block)this);
            for (Direction dir : Direction.values()) {
                world.m_46672_(pos.m_121945_(dir), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_() && !world.f_46443_) {
            this.updateSurroundingSaltPower(world, pos, state);
            for (Direction dir : Direction.Plane.VERTICAL) {
                world.m_46672_(pos.m_121945_(dir), (Block)this);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                this.notifyTrailNeighborsOfStateChange(world, pos.m_121945_(dir));
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.m_121945_(dir);
                if (world.m_8055_(offsetPos).m_60796_((BlockGetter)world, offsetPos)) {
                    this.notifyTrailNeighborsOfStateChange(world, offsetPos.m_7494_());
                    continue;
                }
                this.notifyTrailNeighborsOfStateChange(world, offsetPos.m_7495_());
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, world, pos, newState, isMoving);
            if (!world.f_46443_) {
                for (Direction dir : Direction.values()) {
                    world.m_46672_(pos.m_121945_(dir), (Block)this);
                }
                this.updateSurroundingSaltPower(world, pos, state);
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    this.notifyTrailNeighborsOfStateChange(world, pos.m_121945_(dir));
                }
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos offsetPos = pos.m_121945_(dir);
                    if (world.m_8055_(offsetPos).m_60796_((BlockGetter)world, offsetPos)) {
                        this.notifyTrailNeighborsOfStateChange(world, offsetPos.m_7494_());
                        continue;
                    }
                    this.notifyTrailNeighborsOfStateChange(world, offsetPos.m_7495_());
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_) {
            if (state.m_60710_((LevelReader)world, pos)) {
                this.updateSurroundingSaltPower(world, pos, state);
            } else {
                SaltTrailBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_7471_(pos, false);
            }
        }
    }

    @Override
    public int getStrongSaltPower(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.canProvidePower ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    protected boolean isPowerSourceAt(BlockGetter world, BlockPos pos, Direction side) {
        BlockPos offsetPos = pos.m_121945_(side);
        BlockState offsetState = world.m_8055_(offsetPos);
        boolean isOffsetNormal = offsetState.m_60796_(world, offsetPos);
        BlockPos upPos = pos.m_7494_();
        boolean isUpNormal = world.m_8055_(upPos).m_60796_(world, upPos);
        if (!isUpNormal && isOffsetNormal && this.canConnectTo(world.m_8055_(offsetPos.m_7494_()), world, offsetPos.m_7494_(), null)) {
            return true;
        }
        if (this.canConnectTo(offsetState, world, offsetPos, side)) {
            return true;
        }
        return !isOffsetNormal && this.canConnectTo(world.m_8055_(offsetPos.m_7495_()), world, offsetPos.m_7495_(), null);
    }

    public static int colorMultiplier(int power) {
        float powerRatio = (float)power / 15.0f;
        float colorRatio = power == 0 ? 0.6f : powerRatio * 0.3f + 0.7f;
        int color = Mth.m_14045_((int)((int)(colorRatio * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | color << 16 | color << 8 | color;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int power = (Integer)state.m_61143_((Property)POWER);
        if (power > 0) {
            double x = (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.2;
            double y = (float)pos.m_123342_() + 0.0625f;
            double z = (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.2;
            float powerRatio = (float)power / 15.0f;
            float colorRatio = power == 0 ? 0.6f : powerRatio * 0.3f + 0.7f;
            world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(colorRatio, colorRatio, colorRatio), 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(SOUTH)))))).m_61124_(EAST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(WEST)))))).m_61124_(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(NORTH)))))).m_61124_(WEST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(EAST)))))).m_61124_(EAST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(NORTH)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(WEST)))))).m_61124_(EAST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(NORTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(EAST)))))).m_61124_(WEST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(SOUTH)))));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(SOUTH)))))).m_61124_(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(WEST)))))).m_61124_(WEST, (Comparable)((Object)((SaltSide)((Object)state.m_61143_(EAST)))));
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, POWER});
    }
}

