/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.trees;

import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IForgeShearable;

public abstract class AbstractPhasingLeavesBlock
extends Block
implements IForgeShearable {
    public static final EnumProperty<TimePhase> PHASE = EnumProperty.m_61587_((String)"phase", TimePhase.class);
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;

    public AbstractPhasingLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(PHASE, (Comparable)((Object)TimePhase.FULL))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public abstract TimePhase getCurrentPhase(LevelAccessor var1);

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, PERSISTENT, PHASE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        TimePhase phase = this.getCurrentPhase((LevelAccessor)context.m_43725_());
        return AbstractPhasingLeavesBlock.updateDistance((BlockState)((BlockState)this.m_49966_().m_61124_(PHASE, (Comparable)((Object)phase))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)DISTANCE) == 7 && (Boolean)state.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        TimePhase newPhase;
        if (!((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue() && (Integer)state.m_61143_((Property)DISTANCE) == 7) {
            AbstractPhasingLeavesBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.m_7471_(pos, false);
        }
        if ((newPhase = this.getCurrentPhase((LevelAccessor)worldIn)) != state.m_61143_(PHASE)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_(PHASE, (Comparable)((Object)newPhase)), 3);
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        worldIn.m_7731_(pos, AbstractPhasingLeavesBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        TimePhase newPhase;
        int i = AbstractPhasingLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.m_61143_((Property)DISTANCE) != i) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        if ((newPhase = this.getCurrentPhase(worldIn)) != stateIn.m_61143_(PHASE)) {
            stateIn = (BlockState)stateIn.m_61124_(PHASE, (Comparable)((Object)newPhase));
        }
        return stateIn;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor world, BlockPos pos) {
        int dist = 7;
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            mbp.m_122190_((Vec3i)pos).m_122173_(dir);
            dist = Math.min(dist, AbstractPhasingLeavesBlock.getDistance(world.m_8055_((BlockPos)mbp)) + 1);
            if (dist == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(dist));
    }

    private static int getDistance(BlockState neighbor) {
        if (neighbor.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        if (neighbor.m_60734_() instanceof AbstractPhasingLeavesBlock || neighbor.m_60734_() instanceof LeavesBlock) {
            return (Integer)neighbor.m_61143_((Property)DISTANCE);
        }
        return 7;
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.m_46758_(pos.m_7494_()) || rand.m_188503_(15) != 1 || (blockstate = worldIn.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP))) {
            double x = (double)pos.m_123341_() + rand.m_188500_();
            double y = (double)pos.m_123342_() - 0.05;
            double z = (double)pos.m_123343_() + rand.m_188500_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected static Boolean allowsSpawnOnLeaves(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.f_20505_ || entity == EntityType.f_20508_;
    }
}

