/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.client.books.ClientBookHelper;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.books.LexiconManager;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringDecomposer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class BookHelper {
    public static final Pattern WORD_BOUNDARY = Pattern.compile("\\b");
    public static final Pattern SEPARATOR_ONLY = Pattern.compile("^[\\p{P} \\n]+$");
    public static final Style BASE_TEXT_STYLE = Style.f_131099_;
    private static Function<BookView, Component> memoizedTitleText = Util.m_143827_(BookHelper::getTitleTextInner);
    private static BiFunction<BookView, Component, Component> memoizedAuthorText = Util.m_143821_(BookHelper::getAuthorTextInner);

    public static void invalidate() {
        memoizedTitleText = Util.m_143827_(BookHelper::getTitleTextInner);
        memoizedAuthorText = Util.m_143821_(BookHelper::getAuthorTextInner);
    }

    public static String getTitleTranslationKey(ResourceKey<?> bookKey) {
        if (bookKey.m_135783_(RegistryKeysPM.BOOKS)) {
            return String.join((CharSequence)".", "written_book", bookKey.m_135782_().m_135827_(), bookKey.m_135782_().m_135815_(), "title");
        }
        return "tooltip.primalmagick.question_marks";
    }

    public static Component getTitleText(BookView view) {
        return memoizedTitleText.apply(view);
    }

    private static Component getTitleTextInner(BookView view) {
        MutableComponent retVal = Component.m_237119_();
        String titleTranslationKey = BookHelper.getTitleTranslationKey(view.bookKey());
        BookLanguage lang = BookLanguagesPM.LANGUAGES.get().containsKey(view.languageId()) ? (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(view.languageId()) : (BookLanguage)BookLanguagesPM.DEFAULT.get();
        Lexicon langLex = LexiconManager.getLexicon(lang.languageId()).orElseThrow();
        Lexicon loremLex = LexiconManager.getLexicon(LexiconManager.LOREM_IPSUM).orElseThrow();
        Stream.of(WORD_BOUNDARY.split(StringDecomposer.m_14326_((FormattedText)Component.m_237115_((String)titleTranslationKey)))).forEach(word -> {
            if (SEPARATOR_ONLY.matcher((CharSequence)word).matches()) {
                retVal.m_7220_((Component)Component.m_237113_((String)word).m_130948_(BASE_TEXT_STYLE));
            } else if (lang.isTranslatable() && langLex.isWordTranslated((String)word, view.comprehension(), lang.complexity())) {
                retVal.m_7220_((Component)Component.m_237113_((String)word).m_130948_(BASE_TEXT_STYLE));
            } else {
                retVal.m_7220_((Component)Component.m_237113_((String)loremLex.getReplacementWord((String)word)).m_130948_(lang.style()));
            }
        });
        return retVal;
    }

    public static Component getAuthorText(BookView view, Component unencodedText) {
        return memoizedAuthorText.apply(view, unencodedText);
    }

    private static Component getAuthorTextInner(BookView view, Component unencodedText) {
        MutableComponent retVal = Component.m_237119_();
        BookLanguage lang = BookLanguagesPM.LANGUAGES.get().containsKey(view.languageId()) ? (BookLanguage)BookLanguagesPM.LANGUAGES.get().getValue(view.languageId()) : (BookLanguage)BookLanguagesPM.DEFAULT.get();
        Lexicon langLex = LexiconManager.getLexicon(lang.languageId()).orElseThrow();
        Lexicon loremLex = LexiconManager.getLexicon(LexiconManager.LOREM_IPSUM).orElseThrow();
        Stream.of(WORD_BOUNDARY.split(StringDecomposer.m_14326_((FormattedText)unencodedText))).forEach(word -> {
            if (SEPARATOR_ONLY.matcher((CharSequence)word).matches()) {
                retVal.m_7220_((Component)Component.m_237113_((String)word).m_130948_(BASE_TEXT_STYLE));
            } else if (lang.isTranslatable() && langLex.isWordTranslated((String)word, view.comprehension(), lang.complexity())) {
                retVal.m_7220_((Component)Component.m_237113_((String)word).m_130948_(BASE_TEXT_STYLE));
            } else {
                retVal.m_7220_((Component)Component.m_237113_((String)loremLex.getReplacementWord((String)word)).m_130948_(lang.style()));
            }
        });
        return retVal;
    }

    public static double getBookComprehension(BookView view) {
        return FMLEnvironment.dist == Dist.CLIENT ? ClientBookHelper.getBookComprehension(view) : 0.0;
    }
}

